/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;

class StreamConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STREAM_TYPE = TypeDescriptor.valueOf(Stream.class);
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES = StreamConverter.createConvertibleTypes();
    private final ConversionService conversionService;

    public StreamConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_TYPES;
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor.isAssignableTo(STREAM_TYPE)) {
            return this.matchesFromStream(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2);
        }
        if (typeDescriptor2.isAssignableTo(STREAM_TYPE)) {
            return this.matchesToStream(typeDescriptor2.getElementTypeDescriptor(), typeDescriptor);
        }
        return false;
    }

    public boolean matchesFromStream(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        TypeDescriptor typeDescriptor3 = TypeDescriptor.collection(Collection.class, typeDescriptor);
        return this.conversionService.canConvert(typeDescriptor3, typeDescriptor2);
    }

    public boolean matchesToStream(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        TypeDescriptor typeDescriptor3 = TypeDescriptor.collection(Collection.class, typeDescriptor);
        return this.conversionService.canConvert(typeDescriptor2, typeDescriptor3);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor.isAssignableTo(STREAM_TYPE)) {
            return this.convertFromStream((Stream)object, typeDescriptor, typeDescriptor2);
        }
        if (typeDescriptor2.isAssignableTo(STREAM_TYPE)) {
            return this.convertToStream(object, typeDescriptor, typeDescriptor2);
        }
        throw new IllegalStateException("Unexpected source/target types");
    }

    @Nullable
    private Object convertFromStream(@Nullable Stream<?> stream, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        List list = stream != null ? stream.collect(Collectors.toList()) : Collections.emptyList();
        TypeDescriptor typeDescriptor3 = TypeDescriptor.collection(List.class, typeDescriptor.getElementTypeDescriptor());
        return this.conversionService.convert(list, typeDescriptor3, typeDescriptor2);
    }

    private Object convertToStream(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        TypeDescriptor typeDescriptor3 = TypeDescriptor.collection(List.class, typeDescriptor2.getElementTypeDescriptor());
        List list = (List)this.conversionService.convert(object, typeDescriptor, typeDescriptor3);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list.stream();
    }

    private static Set<GenericConverter.ConvertiblePair> createConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
        hashSet.add(new GenericConverter.ConvertiblePair(Stream.class, Collection.class));
        hashSet.add(new GenericConverter.ConvertiblePair(Stream.class, Object[].class));
        hashSet.add(new GenericConverter.ConvertiblePair(Collection.class, Stream.class));
        hashSet.add(new GenericConverter.ConvertiblePair(Object[].class, Stream.class));
        return hashSet;
    }
}

