/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class MapToMapConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public MapToMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Map.class, Map.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return this.canConvertKey(typeDescriptor, typeDescriptor2) && this.canConvertValue(typeDescriptor, typeDescriptor2);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl;
        if (object == null) {
            return null;
        }
        Map map = (Map)object;
        boolean bl2 = bl = !typeDescriptor2.getType().isInstance(object);
        if (!bl && map.isEmpty()) {
            return map;
        }
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getMapKeyTypeDescriptor();
        TypeDescriptor typeDescriptor4 = typeDescriptor2.getMapValueTypeDescriptor();
        ArrayList<MapEntry> arrayList = new ArrayList<MapEntry>(map.size());
        for (Map.Entry object2 : map.entrySet()) {
            Object k = object2.getKey();
            Object v = object2.getValue();
            Object object3 = this.convertKey(k, typeDescriptor, typeDescriptor3);
            Object object4 = this.convertValue(v, typeDescriptor, typeDescriptor4);
            arrayList.add(new MapEntry(object3, object4));
            if (k == object3 && v == object4) continue;
            bl = true;
        }
        if (!bl) {
            return map;
        }
        Map map2 = CollectionFactory.createMap(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, map.size());
        for (MapEntry mapEntry : arrayList) {
            mapEntry.addToMap(map2);
        }
        return map2;
    }

    private boolean canConvertKey(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getMapKeyTypeDescriptor(), typeDescriptor2.getMapKeyTypeDescriptor(), this.conversionService);
    }

    private boolean canConvertValue(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getMapValueTypeDescriptor(), typeDescriptor2.getMapValueTypeDescriptor(), this.conversionService);
    }

    @Nullable
    private Object convertKey(Object object, TypeDescriptor typeDescriptor, @Nullable TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2 == null) {
            return object;
        }
        return this.conversionService.convert(object, typeDescriptor.getMapKeyTypeDescriptor(object), typeDescriptor2);
    }

    @Nullable
    private Object convertValue(Object object, TypeDescriptor typeDescriptor, @Nullable TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2 == null) {
            return object;
        }
        return this.conversionService.convert(object, typeDescriptor.getMapValueTypeDescriptor(object), typeDescriptor2);
    }

    private static class MapEntry {
        @Nullable
        private final Object key;
        @Nullable
        private final Object value;

        public MapEntry(@Nullable Object object, @Nullable Object object2) {
            this.key = object;
            this.value = object2;
        }

        public void addToMap(Map<Object, Object> map) {
            map.put(this.key, this.value);
        }
    }
}

