/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.converter;

import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface GenericConverter {
    @Nullable
    public Set<ConvertiblePair> getConvertibleTypes();

    @Nullable
    public Object convert(@Nullable Object var1, TypeDescriptor var2, TypeDescriptor var3);

    public static final class ConvertiblePair {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public ConvertiblePair(Class<?> clazz, Class<?> clazz2) {
            Assert.notNull(clazz, "Source type must not be null");
            Assert.notNull(clazz2, "Target type must not be null");
            this.sourceType = clazz;
            this.targetType = clazz2;
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != ConvertiblePair.class) {
                return false;
            }
            ConvertiblePair convertiblePair = (ConvertiblePair)object;
            return this.sourceType == convertiblePair.sourceType && this.targetType == convertiblePair.targetType;
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 31 + this.targetType.hashCode();
        }

        public String toString() {
            return this.sourceType.getName() + " -> " + this.targetType.getName();
        }
    }
}

