/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.Property;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TypeDescriptor
implements Serializable {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Map<Class<?>, TypeDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElementAdapter annotatedElement;

    public TypeDescriptor(MethodParameter methodParameter) {
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getNestedParameterType());
        this.annotatedElement = new AnnotatedElementAdapter(methodParameter.getParameterIndex() == -1 ? methodParameter.getMethodAnnotations() : methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Field field) {
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotatedElement = new AnnotatedElementAdapter(field.getAnnotations());
    }

    public TypeDescriptor(Property property) {
        Assert.notNull((Object)property, "Property must not be null");
        this.resolvableType = ResolvableType.forMethodParameter(property.getMethodParameter());
        this.type = this.resolvableType.resolve(property.getType());
        this.annotatedElement = new AnnotatedElementAdapter(property.getAnnotations());
    }

    public TypeDescriptor(ResolvableType resolvableType, @Nullable Class<?> clazz, @Nullable Annotation[] annotationArray) {
        this.resolvableType = resolvableType;
        this.type = clazz != null ? clazz : resolvableType.toClass();
        this.annotatedElement = new AnnotatedElementAdapter(annotationArray);
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType.getSource();
    }

    public TypeDescriptor narrow(@Nullable Object object) {
        if (object == null) {
            return this;
        }
        ResolvableType resolvableType = ResolvableType.forType(object.getClass(), this.getResolvableType());
        return new TypeDescriptor(resolvableType, object.getClass(), this.getAnnotations());
    }

    @Nullable
    public TypeDescriptor upcast(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Assert.isAssignable(clazz, this.getType());
        return new TypeDescriptor(this.getResolvableType().as(clazz), clazz, this.getAnnotations());
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotatedElement.getAnnotations();
    }

    public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        if (this.annotatedElement.isEmpty()) {
            return false;
        }
        return AnnotatedElementUtils.isAnnotated((AnnotatedElement)this.annotatedElement, clazz);
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (this.annotatedElement.isEmpty()) {
            return null;
        }
        return AnnotatedElementUtils.getMergedAnnotation(this.annotatedElement, clazz);
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean bl = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!bl) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(@Nullable TypeDescriptor typeDescriptor, @Nullable TypeDescriptor typeDescriptor2) {
        return typeDescriptor == null || typeDescriptor2 == null || typeDescriptor.isAssignableTo(typeDescriptor2);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    @Nullable
    public TypeDescriptor getElementTypeDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new TypeDescriptor(this.getResolvableType().getComponentType(), null, this.getAnnotations());
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asCollection().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor elementTypeDescriptor(Object object) {
        return this.narrow(object, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Nullable
    public TypeDescriptor getMapKeyTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor getMapKeyTypeDescriptor(Object object) {
        return this.narrow(object, this.getMapKeyTypeDescriptor());
    }

    @Nullable
    public TypeDescriptor getMapValueTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(1));
    }

    @Nullable
    public TypeDescriptor getMapValueTypeDescriptor(Object object) {
        return this.narrow(object, this.getMapValueTypeDescriptor());
    }

    @Nullable
    private TypeDescriptor narrow(@Nullable Object object, @Nullable TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(object);
        }
        if (object != null) {
            return this.narrow(object);
        }
        return null;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        if (this.getType() != typeDescriptor.getType()) {
            return false;
        }
        if (!this.annotationsMatch(typeDescriptor)) {
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return ObjectUtils.nullSafeEquals(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap()) {
            return ObjectUtils.nullSafeEquals(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && ObjectUtils.nullSafeEquals(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean annotationsMatch(TypeDescriptor typeDescriptor) {
        Annotation[] annotationArray;
        Annotation[] annotationArray2 = this.getAnnotations();
        if (annotationArray2 == (annotationArray = typeDescriptor.getAnnotations())) {
            return true;
        }
        if (annotationArray2.length != annotationArray.length) {
            return false;
        }
        if (annotationArray2.length > 0) {
            for (int i = 0; i < annotationArray2.length; ++i) {
                if (this.annotationEquals(annotationArray2[i], annotationArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation annotation, Annotation annotation2) {
        return annotation == annotation2 || annotation.getClass() == annotation2.getClass() && annotation.equals(annotation2);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Annotation annotation : this.getAnnotations()) {
            stringBuilder.append("@").append(annotation.annotationType().getName()).append(' ');
        }
        stringBuilder.append(this.getResolvableType().toString());
        return stringBuilder.toString();
    }

    @Nullable
    public static TypeDescriptor forObject(@Nullable Object object) {
        return object != null ? TypeDescriptor.valueOf(object.getClass()) : null;
    }

    public static TypeDescriptor valueOf(@Nullable Class<?> clazz) {
        TypeDescriptor typeDescriptor;
        if (clazz == null) {
            clazz = Object.class;
        }
        return (typeDescriptor = commonTypesCache.get(clazz)) != null ? typeDescriptor : new TypeDescriptor(ResolvableType.forClass(clazz), null, null);
    }

    public static TypeDescriptor collection(Class<?> clazz, @Nullable TypeDescriptor typeDescriptor) {
        Assert.notNull(clazz, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType resolvableType = typeDescriptor != null ? typeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(clazz, resolvableType), null, null);
    }

    public static TypeDescriptor map(Class<?> clazz, @Nullable TypeDescriptor typeDescriptor, @Nullable TypeDescriptor typeDescriptor2) {
        Assert.notNull(clazz, "Map type must not be null");
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType resolvableType = typeDescriptor != null ? typeDescriptor.resolvableType : null;
        ResolvableType resolvableType2 = typeDescriptor2 != null ? typeDescriptor2.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(clazz, resolvableType, resolvableType2), null, null);
    }

    @Nullable
    public static TypeDescriptor array(@Nullable TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return null;
        }
        return new TypeDescriptor(ResolvableType.forArrayComponent(typeDescriptor.resolvableType), null, typeDescriptor.getAnnotations());
    }

    @Nullable
    public static TypeDescriptor nested(MethodParameter methodParameter, int n) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return TypeDescriptor.nested(new TypeDescriptor(methodParameter), n);
    }

    @Nullable
    public static TypeDescriptor nested(Field field, int n) {
        return TypeDescriptor.nested(new TypeDescriptor(field), n);
    }

    @Nullable
    public static TypeDescriptor nested(Property property, int n) {
        return TypeDescriptor.nested(new TypeDescriptor(property), n);
    }

    @Nullable
    private static TypeDescriptor nested(TypeDescriptor typeDescriptor, int n) {
        ResolvableType resolvableType = typeDescriptor.resolvableType;
        for (int i = 0; i < n; ++i) {
            if (Object.class == resolvableType.getType()) continue;
            resolvableType = resolvableType.getNested(2);
        }
        if (resolvableType == ResolvableType.NONE) {
            return null;
        }
        return TypeDescriptor.getRelatedIfResolvable(typeDescriptor, resolvableType);
    }

    @Nullable
    private static TypeDescriptor getRelatedIfResolvable(TypeDescriptor typeDescriptor, ResolvableType resolvableType) {
        if (resolvableType.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(resolvableType, null, typeDescriptor.getAnnotations());
    }

    static {
        for (Class<?> clazz : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(clazz, TypeDescriptor.valueOf(clazz));
        }
    }

    private class AnnotatedElementAdapter
    implements Serializable,
    AnnotatedElement {
        @Nullable
        private final Annotation[] annotations;

        public AnnotatedElementAdapter(@Nullable Annotation[] annotationArray) {
            this.annotations = annotationArray;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
            for (Annotation annotation : this.getAnnotations()) {
                if (annotation.annotationType() != clazz) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            for (Annotation annotation : this.getAnnotations()) {
                if (annotation.annotationType() != clazz) continue;
                return (T)annotation;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations != null ? (Annotation[])this.annotations.clone() : EMPTY_ANNOTATION_ARRAY;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        public boolean isEmpty() {
            return ObjectUtils.isEmpty(this.annotations);
        }

        public boolean equals(@Nullable Object object) {
            return this == object || object instanceof AnnotatedElementAdapter && Arrays.equals(this.annotations, ((AnnotatedElementAdapter)object).annotations);
        }

        public int hashCode() {
            return Arrays.hashCode(this.annotations);
        }

        public String toString() {
            return TypeDescriptor.this.toString();
        }
    }
}

