/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class Property {
    private static final Map<Property, Annotation[]> annotationCache = new ConcurrentReferenceHashMap<Property, Annotation[]>();
    private final Class<?> objectType;
    @Nullable
    private final Method readMethod;
    @Nullable
    private final Method writeMethod;
    private final String name;
    private final MethodParameter methodParameter;
    @Nullable
    private Annotation[] annotations;

    public Property(Class<?> clazz, @Nullable Method method, @Nullable Method method2) {
        this(clazz, method, method2, null);
    }

    public Property(Class<?> clazz, @Nullable Method method, @Nullable Method method2, @Nullable String string) {
        this.objectType = clazz;
        this.readMethod = method;
        this.writeMethod = method2;
        this.methodParameter = this.resolveMethodParameter();
        this.name = string != null ? string : this.resolveName();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    @Nullable
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Nullable
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int n = this.readMethod.getName().indexOf("get");
            if (n != -1) {
                n += 3;
            } else {
                n = this.readMethod.getName().indexOf("is");
                if (n == -1) {
                    throw new IllegalArgumentException("Not a getter method");
                }
                n += 2;
            }
            return StringUtils.uncapitalize(this.readMethod.getName().substring(n));
        }
        if (this.writeMethod != null) {
            int n = this.writeMethod.getName().indexOf("set");
            if (n == -1) {
                throw new IllegalArgumentException("Not a setter method");
            }
            return StringUtils.uncapitalize(this.writeMethod.getName().substring(n += 3));
        }
        throw new IllegalStateException("Property is neither readable nor writeable");
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter methodParameter = this.resolveReadMethodParameter();
        MethodParameter methodParameter2 = this.resolveWriteMethodParameter();
        if (methodParameter2 == null) {
            if (methodParameter == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return methodParameter;
        }
        if (methodParameter != null) {
            Class<?> clazz = methodParameter.getParameterType();
            Class<?> clazz2 = methodParameter2.getParameterType();
            if (!clazz2.equals(clazz) && clazz2.isAssignableFrom(clazz)) {
                return methodParameter;
            }
        }
        return methodParameter2;
    }

    @Nullable
    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getReadMethod(), -1).withContainingClass(this.getObjectType());
    }

    @Nullable
    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getWriteMethod(), 0).withContainingClass(this.getObjectType());
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotationArray = annotationCache.get(this);
        if (annotationArray == null) {
            LinkedHashMap<Class<? extends Annotation>, Annotation> linkedHashMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(linkedHashMap, this.getReadMethod());
            this.addAnnotationsToMap(linkedHashMap, this.getWriteMethod());
            this.addAnnotationsToMap(linkedHashMap, this.getField());
            annotationArray = linkedHashMap.values().toArray(new Annotation[0]);
            annotationCache.put(this, annotationArray);
        }
        return annotationArray;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> map, @Nullable AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            for (Annotation annotation : annotatedElement.getAnnotations()) {
                map.put(annotation.annotationType(), annotation);
            }
        }
    }

    @Nullable
    private Field getField() {
        String string = this.getName();
        if (!StringUtils.hasLength(string)) {
            return null;
        }
        Field field = null;
        Class<?> clazz = this.declaringClass();
        if (clazz != null && (field = ReflectionUtils.findField(clazz, string)) == null && (field = ReflectionUtils.findField(clazz, StringUtils.uncapitalize(string))) == null) {
            field = ReflectionUtils.findField(clazz, StringUtils.capitalize(string));
        }
        return field;
    }

    @Nullable
    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        if (this.getWriteMethod() != null) {
            return this.getWriteMethod().getDeclaringClass();
        }
        return null;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        return ObjectUtils.nullSafeEquals(this.objectType, property.objectType) && ObjectUtils.nullSafeEquals(this.name, property.name) && ObjectUtils.nullSafeEquals(this.readMethod, property.readMethod) && ObjectUtils.nullSafeEquals(this.writeMethod, property.writeMethod);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.objectType) * 31 + ObjectUtils.nullSafeHashCode(this.name);
    }
}

