/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class ResourceDecoder
extends AbstractDataBufferDecoder<Resource> {
    public static String FILENAME_HINT = ResourceDecoder.class.getName() + ".filename";

    public ResourceDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return Resource.class.isAssignableFrom(resolvableType.toClass()) && super.canDecode(resolvableType, mimeType);
    }

    @Override
    public Flux<Resource> decode(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(this.decodeToMono(publisher, resolvableType, mimeType, map));
    }

    @Override
    public Resource decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        String string;
        final byte[] byArray = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(byArray);
        DataBufferUtils.release(dataBuffer);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(map) + "Read " + byArray.length + " bytes");
        }
        Class<?> clazz = resolvableType.toClass();
        String string2 = string = map != null ? (String)map.get(FILENAME_HINT) : null;
        if (clazz == InputStreamResource.class) {
            return new InputStreamResource(new ByteArrayInputStream(byArray)){

                @Override
                public String getFilename() {
                    return string;
                }

                @Override
                public long contentLength() {
                    return byArray.length;
                }
            };
        }
        if (Resource.class.isAssignableFrom(clazz)) {
            return new ByteArrayResource(byArray){

                @Override
                public String getFilename() {
                    return string;
                }
            };
        }
        throw new IllegalStateException("Unsupported resource class: " + clazz);
    }
}

