/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class ByteBufferEncoder
extends AbstractEncoder<ByteBuffer> {
    public ByteBufferEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        Class<?> clazz = resolvableType.toClass();
        return super.canEncode(resolvableType, mimeType) && ByteBuffer.class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends ByteBuffer> publisher, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(publisher).map(byteBuffer -> this.encodeValue((ByteBuffer)byteBuffer, dataBufferFactory, resolvableType, mimeType, map));
    }

    @Override
    public DataBuffer encodeValue(ByteBuffer byteBuffer, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        DataBuffer dataBuffer = dataBufferFactory.wrap(byteBuffer);
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            String string = Hints.getLogPrefix(map);
            this.logger.debug(string + "Writing " + dataBuffer.readableByteCount() + " bytes");
        }
        return dataBuffer;
    }
}

