/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.ByteBuffer;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class ByteBufferDecoder
extends AbstractDataBufferDecoder<ByteBuffer> {
    public ByteBufferDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return ByteBuffer.class.isAssignableFrom(resolvableType.toClass()) && super.canDecode(resolvableType, mimeType);
    }

    @Override
    public ByteBuffer decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        int n = dataBuffer.readableByteCount();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(dataBuffer.asByteBuffer());
        byteBuffer.flip();
        DataBufferUtils.release(dataBuffer);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(map) + "Read " + n + " bytes");
        }
        return byteBuffer;
    }
}

