/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class ByteArrayDecoder
extends AbstractDataBufferDecoder<byte[]> {
    public ByteArrayDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return resolvableType.resolve() == byte[].class && super.canDecode(resolvableType, mimeType);
    }

    @Override
    public byte[] decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        byte[] byArray = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(byArray);
        DataBufferUtils.release(dataBuffer);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(map) + "Read " + byArray.length + " bytes");
        }
        return byArray;
    }
}

