/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

public abstract class AbstractDecoder<T>
implements Decoder<T> {
    private final List<MimeType> decodableMimeTypes;
    protected Log logger = LogFactory.getLog(this.getClass());

    protected AbstractDecoder(MimeType ... mimeTypeArray) {
        this.decodableMimeTypes = Arrays.asList(mimeTypeArray);
    }

    public void setLogger(Log log) {
        this.logger = log;
    }

    public Log getLogger() {
        return this.logger;
    }

    @Override
    public List<MimeType> getDecodableMimeTypes() {
        return this.decodableMimeTypes;
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType mimeType2 : this.decodableMimeTypes) {
            if (!mimeType2.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Mono<T> decodeToMono(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }
}

