/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class MergedAnnotationPredicates {
    private MergedAnnotationPredicates() {
    }

    public static <A extends Annotation> Predicate<MergedAnnotation<? extends A>> typeIn(String ... stringArray) {
        return mergedAnnotation -> ObjectUtils.containsElement(stringArray, mergedAnnotation.getType().getName());
    }

    public static <A extends Annotation> Predicate<MergedAnnotation<? extends A>> typeIn(Class<?> ... classArray) {
        return mergedAnnotation -> ObjectUtils.containsElement(classArray, mergedAnnotation.getType());
    }

    public static <A extends Annotation> Predicate<MergedAnnotation<? extends A>> typeIn(Collection<?> collection) {
        return mergedAnnotation -> collection.stream().map(object -> object instanceof Class ? ((Class)object).getName() : object.toString()).anyMatch(string -> string.equals(mergedAnnotation.getType().getName()));
    }

    public static <A extends Annotation> Predicate<MergedAnnotation<A>> firstRunOf(Function<? super MergedAnnotation<A>, ?> function) {
        return new FirstRunOfPredicate(function);
    }

    public static <A extends Annotation, K> Predicate<MergedAnnotation<A>> unique(Function<? super MergedAnnotation<A>, K> function) {
        return new UniquePredicate(function);
    }

    private static class UniquePredicate<A extends Annotation, K>
    implements Predicate<MergedAnnotation<A>> {
        private final Function<? super MergedAnnotation<A>, K> keyExtractor;
        private final Set<K> seen = new HashSet<K>();

        UniquePredicate(Function<? super MergedAnnotation<A>, K> function) {
            Assert.notNull(function, "Key extractor must not be null");
            this.keyExtractor = function;
        }

        @Override
        public boolean test(@Nullable MergedAnnotation<A> mergedAnnotation) {
            K k = this.keyExtractor.apply(mergedAnnotation);
            return this.seen.add(k);
        }
    }

    private static class FirstRunOfPredicate<A extends Annotation>
    implements Predicate<MergedAnnotation<A>> {
        private final Function<? super MergedAnnotation<A>, ?> valueExtractor;
        private boolean hasLastValue;
        @Nullable
        private Object lastValue;

        FirstRunOfPredicate(Function<? super MergedAnnotation<A>, ?> function) {
            Assert.notNull(function, "Value extractor must not be null");
            this.valueExtractor = function;
        }

        @Override
        public boolean test(@Nullable MergedAnnotation<A> mergedAnnotation) {
            if (!this.hasLastValue) {
                this.hasLastValue = true;
                this.lastValue = this.valueExtractor.apply(mergedAnnotation);
            }
            Object obj = this.valueExtractor.apply(mergedAnnotation);
            return ObjectUtils.nullSafeEquals(obj, this.lastValue);
        }
    }
}

