/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class AbstractMergedAnnotation<A extends Annotation>
implements MergedAnnotation<A> {
    @Nullable
    private volatile A synthesizedAnnotation;

    AbstractMergedAnnotation() {
    }

    @Override
    public boolean isDirectlyPresent() {
        return this.isPresent() && this.getDistance() == 0;
    }

    @Override
    public boolean isMetaPresent() {
        return this.isPresent() && this.getDistance() > 0;
    }

    @Override
    public boolean hasNonDefaultValue(String string) {
        return !this.hasDefaultValue(string);
    }

    @Override
    public byte getByte(String string) {
        return this.getRequiredAttributeValue(string, Byte.class);
    }

    @Override
    public byte[] getByteArray(String string) {
        return this.getRequiredAttributeValue(string, byte[].class);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getRequiredAttributeValue(string, Boolean.class);
    }

    @Override
    public boolean[] getBooleanArray(String string) {
        return this.getRequiredAttributeValue(string, boolean[].class);
    }

    @Override
    public char getChar(String string) {
        return this.getRequiredAttributeValue(string, Character.class).charValue();
    }

    @Override
    public char[] getCharArray(String string) {
        return this.getRequiredAttributeValue(string, char[].class);
    }

    @Override
    public short getShort(String string) {
        return this.getRequiredAttributeValue(string, Short.class);
    }

    @Override
    public short[] getShortArray(String string) {
        return this.getRequiredAttributeValue(string, short[].class);
    }

    @Override
    public int getInt(String string) {
        return this.getRequiredAttributeValue(string, Integer.class);
    }

    @Override
    public int[] getIntArray(String string) {
        return this.getRequiredAttributeValue(string, int[].class);
    }

    @Override
    public long getLong(String string) {
        return this.getRequiredAttributeValue(string, Long.class);
    }

    @Override
    public long[] getLongArray(String string) {
        return this.getRequiredAttributeValue(string, long[].class);
    }

    @Override
    public double getDouble(String string) {
        return this.getRequiredAttributeValue(string, Double.class);
    }

    @Override
    public double[] getDoubleArray(String string) {
        return this.getRequiredAttributeValue(string, double[].class);
    }

    @Override
    public float getFloat(String string) {
        return this.getRequiredAttributeValue(string, Float.class).floatValue();
    }

    @Override
    public float[] getFloatArray(String string) {
        return this.getRequiredAttributeValue(string, float[].class);
    }

    @Override
    public String getString(String string) {
        return this.getRequiredAttributeValue(string, String.class);
    }

    @Override
    public String[] getStringArray(String string) {
        return this.getRequiredAttributeValue(string, String[].class);
    }

    @Override
    public Class<?> getClass(String string) {
        return this.getRequiredAttributeValue(string, Class.class);
    }

    @Override
    public Class<?>[] getClassArray(String string) {
        return this.getRequiredAttributeValue(string, Class[].class);
    }

    @Override
    public <E extends Enum<E>> E getEnum(String string, Class<E> clazz) {
        Assert.notNull(clazz, "Type must not be null");
        return (E)((Enum)this.getRequiredAttributeValue(string, clazz));
    }

    @Override
    public <E extends Enum<E>> E[] getEnumArray(String string, Class<E> clazz) {
        Assert.notNull(clazz, "Type must not be null");
        Class<?> clazz2 = Array.newInstance(clazz, 0).getClass();
        return (Enum[])this.getRequiredAttributeValue(string, clazz2);
    }

    @Override
    public Optional<Object> getValue(String string) {
        return this.getValue(string, Object.class);
    }

    @Override
    public <T> Optional<T> getValue(String string, Class<T> clazz) {
        return Optional.ofNullable(this.getAttributeValue(string, clazz));
    }

    @Override
    public Optional<Object> getDefaultValue(String string) {
        return this.getDefaultValue(string, Object.class);
    }

    @Override
    public MergedAnnotation<A> filterDefaultValues() {
        return this.filterAttributes(this::hasNonDefaultValue);
    }

    @Override
    public AnnotationAttributes asAnnotationAttributes(MergedAnnotation.Adapt ... adaptArray) {
        return this.asMap((MergedAnnotation<?> mergedAnnotation) -> new AnnotationAttributes(mergedAnnotation.getType()), adaptArray);
    }

    @Override
    public Optional<A> synthesize(Predicate<? super MergedAnnotation<A>> predicate) throws NoSuchElementException {
        return predicate.test(this) ? Optional.of(this.synthesize()) : Optional.empty();
    }

    @Override
    public A synthesize() {
        if (!this.isPresent()) {
            throw new NoSuchElementException("Unable to synthesize missing annotation");
        }
        A a = this.synthesizedAnnotation;
        if (a == null) {
            this.synthesizedAnnotation = a = this.createSynthesized();
        }
        return a;
    }

    private <T> T getRequiredAttributeValue(String string, Class<T> clazz) {
        T t2 = this.getAttributeValue(string, clazz);
        if (t2 == null) {
            throw new NoSuchElementException("No attribute named '" + string + "' present in merged annotation " + this.getType().getName());
        }
        return t2;
    }

    @Nullable
    protected abstract <T> T getAttributeValue(String var1, Class<T> var2);

    protected abstract A createSynthesized();
}

