/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.AliasRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class SimpleAliasRegistry
implements AliasRegistry {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, String> aliasMap = new ConcurrentHashMap<String, String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAlias(String string, String string2) {
        Assert.hasText(string, "'name' must not be empty");
        Assert.hasText(string2, "'alias' must not be empty");
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            if (string2.equals(string)) {
                this.aliasMap.remove(string2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Alias definition '" + string2 + "' ignored since it points to same name");
                }
            } else {
                String string3 = this.aliasMap.get(string2);
                if (string3 != null) {
                    if (string3.equals(string)) {
                        return;
                    }
                    if (!this.allowAliasOverriding()) {
                        throw new IllegalStateException("Cannot define alias '" + string2 + "' for name '" + string + "': It is already registered for name '" + string3 + "'.");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Overriding alias '" + string2 + "' definition for registered name '" + string3 + "' with new target name '" + string + "'");
                    }
                }
                this.checkForAliasCircle(string, string2);
                this.aliasMap.put(string2, string);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Alias definition '" + string2 + "' registered for name '" + string + "'");
                }
            }
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    public boolean hasAlias(String string, String string2) {
        String string3 = this.aliasMap.get(string2);
        return ObjectUtils.nullSafeEquals(string3, string) || string3 != null && this.hasAlias(string, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlias(String string) {
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            String string2 = this.aliasMap.remove(string);
            if (string2 == null) {
                throw new IllegalStateException("No alias '" + string + "' registered");
            }
        }
    }

    @Override
    public boolean isAlias(String string) {
        return this.aliasMap.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAliases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            this.retrieveAliases(string, arrayList);
        }
        return StringUtils.toStringArray(arrayList);
    }

    private void retrieveAliases(String string, List<String> list) {
        this.aliasMap.forEach((string2, string3) -> {
            if (string3.equals(string)) {
                list.add((String)string2);
                this.retrieveAliases((String)string2, list);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver stringValueResolver) {
        Assert.notNull((Object)stringValueResolver, "StringValueResolver must not be null");
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.aliasMap);
            hashMap.forEach((string, string2) -> {
                String string3 = stringValueResolver.resolveStringValue((String)string);
                String string4 = stringValueResolver.resolveStringValue((String)string2);
                if (string3 == null || string4 == null || string3.equals(string4)) {
                    this.aliasMap.remove(string);
                } else if (!string3.equals(string)) {
                    String string5 = this.aliasMap.get(string3);
                    if (string5 != null) {
                        if (string5.equals(string4)) {
                            this.aliasMap.remove(string);
                            return;
                        }
                        throw new IllegalStateException("Cannot register resolved alias '" + string3 + "' (original: '" + string + "') for name '" + string4 + "': It is already registered for name '" + string2 + "'.");
                    }
                    this.checkForAliasCircle(string4, string3);
                    this.aliasMap.remove(string);
                    this.aliasMap.put(string3, string4);
                } else if (!string2.equals(string4)) {
                    this.aliasMap.put((String)string, string4);
                }
            });
        }
    }

    protected void checkForAliasCircle(String string, String string2) {
        if (this.hasAlias(string2, string)) {
            throw new IllegalStateException("Cannot register alias '" + string2 + "' for name '" + string + "': Circular reference - '" + string + "' is a direct or indirect alias for '" + string2 + "' already");
        }
    }

    public String canonicalName(String string) {
        String string2;
        String string3 = string;
        do {
            if ((string2 = this.aliasMap.get(string3)) == null) continue;
            string3 = string2;
        } while (string2 != null);
        return string3;
    }
}

