/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.Publisher;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveTypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Completable;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.Single;

public class ReactiveAdapterRegistry {
    @Nullable
    private static volatile ReactiveAdapterRegistry sharedInstance;
    private final boolean reactorPresent;
    private final List<ReactiveAdapter> adapters = new ArrayList<ReactiveAdapter>();

    public ReactiveAdapterRegistry() {
        ClassLoader classLoader = ReactiveAdapterRegistry.class.getClassLoader();
        boolean bl = false;
        if (ClassUtils.isPresent("reactor.core.publisher.Flux", classLoader)) {
            new ReactorRegistrar().registerAdapters(this);
            if (ClassUtils.isPresent("java.util.concurrent.Flow.Publisher", classLoader)) {
                new ReactorJdkFlowAdapterRegistrar().registerAdapter(this);
            }
            bl = true;
        }
        this.reactorPresent = bl;
        if (ClassUtils.isPresent("rx.Observable", classLoader) && ClassUtils.isPresent("rx.RxReactiveStreams", classLoader)) {
            new RxJava1Registrar().registerAdapters(this);
        }
        if (ClassUtils.isPresent("io.reactivex.Flowable", classLoader)) {
            new RxJava2Registrar().registerAdapters(this);
        }
        if (this.reactorPresent && ClassUtils.isPresent("kotlinx.coroutines.reactor.MonoKt", classLoader)) {
            new CoroutinesRegistrar().registerAdapters(this);
        }
    }

    public boolean hasAdapters() {
        return !this.adapters.isEmpty();
    }

    public void registerReactiveType(ReactiveTypeDescriptor reactiveTypeDescriptor, Function<Object, Publisher<?>> function, Function<Publisher<?>, Object> function2) {
        if (this.reactorPresent) {
            this.adapters.add(new ReactorAdapter(reactiveTypeDescriptor, function, function2));
        } else {
            this.adapters.add(new ReactiveAdapter(reactiveTypeDescriptor, function, function2));
        }
    }

    @Nullable
    public ReactiveAdapter getAdapter(Class<?> clazz) {
        return this.getAdapter(clazz, null);
    }

    @Nullable
    public ReactiveAdapter getAdapter(@Nullable Class<?> clazz, @Nullable Object object) {
        Class<?> clazz2;
        if (this.adapters.isEmpty()) {
            return null;
        }
        Object object2 = object instanceof Optional ? ((Optional)object).orElse(null) : object;
        Class<?> clazz3 = clazz2 = object2 != null ? object2.getClass() : clazz;
        if (clazz2 == null) {
            return null;
        }
        for (ReactiveAdapter reactiveAdapter : this.adapters) {
            if (reactiveAdapter.getReactiveType() != clazz2) continue;
            return reactiveAdapter;
        }
        for (ReactiveAdapter reactiveAdapter : this.adapters) {
            if (!reactiveAdapter.getReactiveType().isAssignableFrom(clazz2)) continue;
            return reactiveAdapter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReactiveAdapterRegistry getSharedInstance() {
        ReactiveAdapterRegistry reactiveAdapterRegistry = sharedInstance;
        if (reactiveAdapterRegistry != null) return reactiveAdapterRegistry;
        Class<ReactiveAdapterRegistry> clazz = ReactiveAdapterRegistry.class;
        synchronized (ReactiveAdapterRegistry.class) {
            reactiveAdapterRegistry = sharedInstance;
            if (reactiveAdapterRegistry != null) return reactiveAdapterRegistry;
            sharedInstance = reactiveAdapterRegistry = new ReactiveAdapterRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reactiveAdapterRegistry;
        }
    }

    public static class SpringCoreBlockHoundIntegration
    implements BlockHoundIntegration {
        public void applyTo(BlockHound.Builder builder) {
            builder.allowBlockingCallsInside("org.springframework.core.LocalVariableTableParameterNameDiscoverer", "inspectClass");
            String string = "org.springframework.util.ConcurrentReferenceHashMap$Segment";
            builder.allowBlockingCallsInside(string, "doTask");
            builder.allowBlockingCallsInside(string, "clear");
            builder.allowBlockingCallsInside(string, "restructure");
        }
    }

    private static class CoroutinesRegistrar {
        private CoroutinesRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry reactiveAdapterRegistry) {
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Deferred.class, () -> CompletableDeferredKt.CompletableDeferred(null)), object -> CoroutinesUtils.deferredToMono((Deferred)object), publisher -> CoroutinesUtils.monoToDeferred(Mono.from((Publisher)publisher)));
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flow.class, FlowKt::emptyFlow), object -> ReactorFlowKt.asFlux((Flow)((Flow)object)), ReactiveFlowKt::asFlow);
        }
    }

    private static class EmptyCompletableFuture<T>
    extends CompletableFuture<T> {
        EmptyCompletableFuture() {
            this.complete(null);
        }
    }

    private static class ReactorAdapter
    extends ReactiveAdapter {
        ReactorAdapter(ReactiveTypeDescriptor reactiveTypeDescriptor, Function<Object, Publisher<?>> function, Function<Publisher<?>, Object> function2) {
            super(reactiveTypeDescriptor, function, function2);
        }

        @Override
        public <T> Publisher<T> toPublisher(@Nullable Object object) {
            Publisher publisher = super.toPublisher(object);
            return this.isMultiValue() ? Flux.from(publisher) : Mono.from(publisher);
        }
    }

    private static class RxJava2Registrar {
        private RxJava2Registrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry reactiveAdapterRegistry) {
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flowable.class, Flowable::empty), object -> (Flowable)object, Flowable::fromPublisher);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(io.reactivex.Observable.class, io.reactivex.Observable::empty), object -> ((io.reactivex.Observable)object).toFlowable(BackpressureStrategy.BUFFER), publisher -> Flowable.fromPublisher((Publisher)publisher).toObservable());
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.singleRequiredValue(io.reactivex.Single.class), object -> ((io.reactivex.Single)object).toFlowable(), publisher -> Flowable.fromPublisher((Publisher)publisher).toObservable().singleElement().toSingle());
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Maybe.class, Maybe::empty), object -> ((Maybe)object).toFlowable(), publisher -> Flowable.fromPublisher((Publisher)publisher).toObservable().singleElement());
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.noValue(io.reactivex.Completable.class, io.reactivex.Completable::complete), object -> ((io.reactivex.Completable)object).toFlowable(), publisher -> Flowable.fromPublisher((Publisher)publisher).toObservable().ignoreElements());
        }
    }

    private static class RxJava1Registrar {
        private RxJava1Registrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry reactiveAdapterRegistry) {
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Observable.class, Observable::empty), object -> RxReactiveStreams.toPublisher((Observable)((Observable)object)), RxReactiveStreams::toObservable);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.singleRequiredValue(Single.class), object -> RxReactiveStreams.toPublisher((Single)((Single)object)), RxReactiveStreams::toSingle);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.noValue(Completable.class, Completable::complete), object -> RxReactiveStreams.toPublisher((Completable)((Completable)object)), RxReactiveStreams::toCompletable);
        }
    }

    private static class ReactorJdkFlowAdapterRegistrar {
        private ReactorJdkFlowAdapterRegistrar() {
        }

        void registerAdapter(ReactiveAdapterRegistry reactiveAdapterRegistry) {
            try {
                String string = "java.util.concurrent.Flow.Publisher";
                Class<?> clazz = ClassUtils.forName(string, this.getClass().getClassLoader());
                String string2 = "reactor.adapter.JdkFlowAdapter";
                Class<?> clazz2 = ClassUtils.forName(string2, this.getClass().getClassLoader());
                Method method = clazz2.getMethod("flowPublisherToFlux", clazz);
                Method method2 = clazz2.getMethod("publisherToFlowPublisher", Publisher.class);
                Object object2 = ReflectionUtils.invokeMethod(method2, null, Flux.empty());
                reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(clazz, () -> object2), object -> (Publisher)ReflectionUtils.invokeMethod(method, null, object), publisher -> ReflectionUtils.invokeMethod(method2, null, publisher));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ReactorRegistrar {
        private ReactorRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry reactiveAdapterRegistry) {
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Mono.class, Mono::empty), object -> (Mono)object, Mono::from);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flux.class, Flux::empty), object -> (Flux)object, Flux::from);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Publisher.class, Flux::empty), object -> (Publisher)object, publisher -> publisher);
            reactiveAdapterRegistry.registerReactiveType(ReactiveTypeDescriptor.nonDeferredAsyncValue(CompletionStage.class, EmptyCompletableFuture::new), object -> Mono.fromCompletionStage((CompletionStage)((CompletionStage)object)), publisher -> Mono.from((Publisher)publisher).toFuture());
        }
    }
}

