/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final Log logger = LogFactory.getLog(LocalVariableTableParameterNameDiscoverer.class);
    private static final Map<Executable, String[]> NO_DEBUG_INFO_MAP = Collections.emptyMap();
    private final Map<Class<?>, Map<Executable, String[]>> parameterNamesCache = new ConcurrentHashMap(32);

    @Override
    @Nullable
    public String[] getParameterNames(Method method) {
        Method method2 = BridgeMethodResolver.findBridgedMethod(method);
        return this.doGetParameterNames(method2);
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> constructor) {
        return this.doGetParameterNames(constructor);
    }

    @Nullable
    private String[] doGetParameterNames(Executable executable) {
        Class<?> clazz = executable.getDeclaringClass();
        Map map = this.parameterNamesCache.computeIfAbsent(clazz, this::inspectClass);
        return map != NO_DEBUG_INFO_MAP ? (String[])map.get(executable) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Executable, String[]> inspectClass(Class<?> clazz) {
        InputStream inputStream2 = clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));
        if (inputStream2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot find '.class' file for class [" + clazz + "] - unable to determine constructor/method parameter names");
            }
            return NO_DEBUG_INFO_MAP;
        }
        try {
            ClassReader classReader = new ClassReader(inputStream2);
            ConcurrentHashMap<Executable, String[]> concurrentHashMap = new ConcurrentHashMap<Executable, String[]>(32);
            classReader.accept(new ParameterNameDiscoveringVisitor(clazz, concurrentHashMap), 0);
            ConcurrentHashMap<Executable, String[]> concurrentHashMap2 = concurrentHashMap;
            return concurrentHashMap2;
        }
        catch (IOException iOException) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception thrown while reading '.class' file for class [" + clazz + "] - unable to determine constructor/method parameter names", iOException);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (logger.isDebugEnabled()) {
                logger.debug("ASM ClassReader failed to parse class file [" + clazz + "], probably due to a new Java class file version that isn't supported yet - unable to determine constructor/method parameter names", illegalArgumentException);
            }
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
        return NO_DEBUG_INFO_MAP;
    }

    private static class LocalVariableTableVisitor
    extends MethodVisitor {
        private static final String CONSTRUCTOR = "<init>";
        private final Class<?> clazz;
        private final Map<Executable, String[]> executableMap;
        private final String name;
        private final Type[] args;
        private final String[] parameterNames;
        private final boolean isStatic;
        private boolean hasLvtInfo = false;
        private final int[] lvtSlotIndex;

        public LocalVariableTableVisitor(Class<?> clazz, Map<Executable, String[]> map, String string, String string2, boolean bl) {
            super(0x1080000);
            this.clazz = clazz;
            this.executableMap = map;
            this.name = string;
            this.args = Type.getArgumentTypes(string2);
            this.parameterNames = new String[this.args.length];
            this.isStatic = bl;
            this.lvtSlotIndex = LocalVariableTableVisitor.computeLvtSlotIndices(bl, this.args);
        }

        @Override
        public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
            this.hasLvtInfo = true;
            for (int i = 0; i < this.lvtSlotIndex.length; ++i) {
                if (this.lvtSlotIndex[i] != n) continue;
                this.parameterNames[i] = string;
            }
        }

        @Override
        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                this.executableMap.put(this.resolveExecutable(), this.parameterNames);
            }
        }

        private Executable resolveExecutable() {
            ClassLoader classLoader = this.clazz.getClassLoader();
            Class[] classArray = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                classArray[i] = ClassUtils.resolveClassName(this.args[i].getClassName(), classLoader);
            }
            try {
                if (CONSTRUCTOR.equals(this.name)) {
                    return this.clazz.getDeclaredConstructor(classArray);
                }
                return this.clazz.getDeclaredMethod(this.name, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("Method [" + this.name + "] was discovered in the .class file but cannot be resolved in the class object", noSuchMethodException);
            }
        }

        private static int[] computeLvtSlotIndices(boolean bl, Type[] typeArray) {
            int[] nArray = new int[typeArray.length];
            int n = bl ? 0 : 1;
            for (int i = 0; i < typeArray.length; ++i) {
                nArray[i] = n++;
                if (!LocalVariableTableVisitor.isWideType(typeArray[i])) continue;
                n += 2;
            }
            return nArray;
        }

        private static boolean isWideType(Type type) {
            return type == Type.LONG_TYPE || type == Type.DOUBLE_TYPE;
        }
    }

    private static class ParameterNameDiscoveringVisitor
    extends ClassVisitor {
        private static final String STATIC_CLASS_INIT = "<clinit>";
        private final Class<?> clazz;
        private final Map<Executable, String[]> executableMap;

        public ParameterNameDiscoveringVisitor(Class<?> clazz, Map<Executable, String[]> map) {
            super(0x1080000);
            this.clazz = clazz;
            this.executableMap = map;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (!ParameterNameDiscoveringVisitor.isSyntheticOrBridged(n) && !STATIC_CLASS_INIT.equals(string)) {
                return new LocalVariableTableVisitor(this.clazz, this.executableMap, string, string2, ParameterNameDiscoveringVisitor.isStatic(n));
            }
            return null;
        }

        private static boolean isSyntheticOrBridged(int n) {
            return (n & 0x1000 | n & 0x40) > 0;
        }

        private static boolean isStatic(int n) {
            return (n & 8) > 0;
        }
    }
}

