/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;

public class KotlinReflectionParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Override
    @Nullable
    public String[] getParameterNames(Method method) {
        if (!KotlinDetector.isKotlinType(method.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
            return kFunction != null ? this.getParameterNames(kFunction.getParameters()) : null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> constructor) {
        if (constructor.getDeclaringClass().isEnum() || !KotlinDetector.isKotlinType(constructor.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction kFunction = ReflectJvmMapping.getKotlinFunction(constructor);
            return kFunction != null ? this.getParameterNames(kFunction.getParameters()) : null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    @Nullable
    private String[] getParameterNames(List<KParameter> list) {
        List list2 = list.stream().filter(kParameter -> KParameter.Kind.VALUE.equals((Object)kParameter.getKind()) || KParameter.Kind.EXTENSION_RECEIVER.equals((Object)kParameter.getKind())).collect(Collectors.toList());
        String[] stringArray = new String[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            String string;
            KParameter kParameter2 = (KParameter)list2.get(i);
            String string2 = string = KParameter.Kind.EXTENSION_RECEIVER.equals((Object)kParameter2.getKind()) ? "$receiver" : kParameter2.getName();
            if (string == null) {
                return null;
            }
            stringArray[i] = string;
        }
        return stringArray;
    }
}

