/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class Conventions {
    private static final String PLURAL_SUFFIX = "List";

    private Conventions() {
    }

    public static String getVariableName(Object object) {
        Object object2;
        Class<?> clazz;
        Assert.notNull(object, "Value must not be null");
        boolean bl = false;
        if (object.getClass().isArray()) {
            clazz = object.getClass().getComponentType();
            bl = true;
        } else if (object instanceof Collection) {
            object2 = (Collection)object;
            if (object2.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object e = Conventions.peekAhead(object2);
            clazz = Conventions.getClassForValue(e);
            bl = true;
        } else {
            clazz = Conventions.getClassForValue(object);
        }
        object2 = ClassUtils.getShortNameAsProperty(clazz);
        return bl ? Conventions.pluralize((String)object2) : object2;
    }

    public static String getVariableNameForParameter(MethodParameter methodParameter) {
        Object object;
        Class<?> clazz;
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        boolean bl = false;
        String string = "";
        if (methodParameter.getParameterType().isArray()) {
            clazz = methodParameter.getParameterType().getComponentType();
            bl = true;
        } else if (Collection.class.isAssignableFrom(methodParameter.getParameterType())) {
            clazz = ResolvableType.forMethodParameter(methodParameter).asCollection().resolveGeneric(new int[0]);
            if (clazz == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            bl = true;
        } else {
            clazz = methodParameter.getParameterType();
            object = ReactiveAdapterRegistry.getSharedInstance().getAdapter(clazz);
            if (object != null && !((ReactiveAdapter)object).getDescriptor().isNoValue()) {
                string = ClassUtils.getShortName(clazz);
                clazz = methodParameter.nested().getNestedParameterType();
            }
        }
        object = ClassUtils.getShortNameAsProperty(clazz);
        return bl ? Conventions.pluralize((String)object) : (String)object + string;
    }

    public static String getVariableNameForReturnType(Method method) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), null);
    }

    public static String getVariableNameForReturnType(Method method, @Nullable Object object) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), object);
    }

    public static String getVariableNameForReturnType(Method method, Class<?> clazz, @Nullable Object object) {
        Object object2;
        Class<?> clazz2;
        Assert.notNull((Object)method, "Method must not be null");
        if (Object.class == clazz) {
            if (object == null) {
                throw new IllegalArgumentException("Cannot generate variable name for an Object return type with null value");
            }
            return Conventions.getVariableName(object);
        }
        boolean bl = false;
        String string = "";
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            bl = true;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            clazz2 = ResolvableType.forMethodReturnType(method).asCollection().resolveGeneric(new int[0]);
            if (clazz2 == null) {
                if (!(object instanceof Collection)) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and a non-Collection value");
                }
                object2 = (Collection)object;
                if (object2.isEmpty()) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and an empty Collection value");
                }
                Object e = Conventions.peekAhead(object2);
                clazz2 = Conventions.getClassForValue(e);
            }
            bl = true;
        } else {
            clazz2 = clazz;
            object2 = ReactiveAdapterRegistry.getSharedInstance().getAdapter(clazz2);
            if (object2 != null && !((ReactiveAdapter)object2).getDescriptor().isNoValue()) {
                string = ClassUtils.getShortName(clazz2);
                clazz2 = ResolvableType.forMethodReturnType(method).getGeneric(new int[0]).toClass();
            }
        }
        object2 = ClassUtils.getShortNameAsProperty(clazz2);
        return bl ? Conventions.pluralize((String)object2) : (String)object2 + string;
    }

    public static String attributeNameToPropertyName(String string) {
        Assert.notNull((Object)string, "'attributeName' must not be null");
        if (!string.contains("-")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length - 1];
        int n = 0;
        boolean bl = false;
        for (char c : cArray) {
            if (c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                cArray2[n++] = Character.toUpperCase(c);
                bl = false;
                continue;
            }
            cArray2[n++] = c;
        }
        return new String(cArray2, 0, n);
    }

    public static String getQualifiedAttributeName(Class<?> clazz, String string) {
        Assert.notNull(clazz, "'enclosingClass' must not be null");
        Assert.notNull((Object)string, "'attributeName' must not be null");
        return clazz.getName() + '.' + string;
    }

    private static Class<?> getClassForValue(Object object) {
        Class<?> clazz = object.getClass();
        if (Proxy.isProxyClass(clazz)) {
            Class<?>[] classArray;
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(clazz2)) continue;
                return clazz2;
            }
        } else if (clazz.getName().lastIndexOf(36) != -1 && clazz.getDeclaringClass() == null) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private static String pluralize(String string) {
        return string + PLURAL_SUFFIX;
    }

    private static <E> E peekAhead(Collection<E> collection) {
        Iterator<E> iterator2 = collection.iterator();
        if (!iterator2.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        E e = iterator2.next();
        if (e == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return e;
    }
}

