/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.core.SortedProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public final class CollectionFactory {
    private static final Set<Class<?>> approximableCollectionTypes = new HashSet();
    private static final Set<Class<?>> approximableMapTypes = new HashSet();

    private CollectionFactory() {
    }

    public static boolean isApproximableCollectionType(@Nullable Class<?> clazz) {
        return clazz != null && approximableCollectionTypes.contains(clazz);
    }

    public static <E> Collection<E> createApproximateCollection(@Nullable Object object, int n) {
        if (object instanceof LinkedList) {
            return new LinkedList();
        }
        if (object instanceof List) {
            return new ArrayList(n);
        }
        if (object instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)object);
            enumSet.clear();
            return enumSet;
        }
        if (object instanceof SortedSet) {
            return new TreeSet(((SortedSet)object).comparator());
        }
        return new LinkedHashSet(n);
    }

    public static <E> Collection<E> createCollection(Class<?> clazz, int n) {
        return CollectionFactory.createCollection(clazz, null, n);
    }

    public static <E> Collection<E> createCollection(Class<?> clazz, @Nullable Class<?> clazz2, int n) {
        Assert.notNull(clazz, "Collection type must not be null");
        if (clazz.isInterface()) {
            if (Set.class == clazz || Collection.class == clazz) {
                return new LinkedHashSet(n);
            }
            if (List.class == clazz) {
                return new ArrayList(n);
            }
            if (SortedSet.class == clazz || NavigableSet.class == clazz) {
                return new TreeSet();
            }
            throw new IllegalArgumentException("Unsupported Collection interface: " + clazz.getName());
        }
        if (EnumSet.class.isAssignableFrom(clazz)) {
            Assert.notNull(clazz2, "Cannot create EnumSet for unknown element type");
            return EnumSet.noneOf(CollectionFactory.asEnumType(clazz2));
        }
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + clazz.getName());
        }
        try {
            return (Collection)ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + clazz.getName(), throwable);
        }
    }

    public static boolean isApproximableMapType(@Nullable Class<?> clazz) {
        return clazz != null && approximableMapTypes.contains(clazz);
    }

    public static <K, V> Map<K, V> createApproximateMap(@Nullable Object object, int n) {
        if (object instanceof EnumMap) {
            EnumMap enumMap = new EnumMap((EnumMap)object);
            enumMap.clear();
            return enumMap;
        }
        if (object instanceof SortedMap) {
            return new TreeMap(((SortedMap)object).comparator());
        }
        return new LinkedHashMap(n);
    }

    public static <K, V> Map<K, V> createMap(Class<?> clazz, int n) {
        return CollectionFactory.createMap(clazz, null, n);
    }

    public static <K, V> Map<K, V> createMap(Class<?> clazz, @Nullable Class<?> clazz2, int n) {
        Assert.notNull(clazz, "Map type must not be null");
        if (clazz.isInterface()) {
            if (Map.class == clazz) {
                return new LinkedHashMap(n);
            }
            if (SortedMap.class == clazz || NavigableMap.class == clazz) {
                return new TreeMap();
            }
            if (MultiValueMap.class == clazz) {
                return new LinkedMultiValueMap();
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + clazz.getName());
        }
        if (EnumMap.class == clazz) {
            Assert.notNull(clazz2, "Cannot create EnumMap for unknown key type");
            return new EnumMap(CollectionFactory.asEnumType(clazz2));
        }
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported Map type: " + clazz.getName());
        }
        try {
            return (Map)ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + clazz.getName(), throwable);
        }
    }

    public static Properties createStringAdaptingProperties() {
        return new SortedProperties(false){

            @Override
            @Nullable
            public String getProperty(String string) {
                Object object = this.get(string);
                return object != null ? object.toString() : null;
            }
        };
    }

    public static Properties createSortedProperties(boolean bl) {
        return new SortedProperties(bl);
    }

    public static Properties createSortedProperties(Properties properties, boolean bl) {
        return new SortedProperties(properties, bl);
    }

    private static Class<? extends Enum> asEnumType(Class<?> clazz) {
        Assert.notNull(clazz, "Enum type must not be null");
        if (!Enum.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Supplied type is not an enum: " + clazz.getName());
        }
        return clazz.asSubclass(Enum.class);
    }

    static {
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableCollectionTypes.add(NavigableSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        approximableMapTypes.add(NavigableMap.class);
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableCollectionTypes.add(EnumSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
        approximableMapTypes.add(EnumMap.class);
    }
}

