/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public final class BridgeMethodResolver {
    private static final Map<Method, Method> cache = new ConcurrentReferenceHashMap<Method, Method>();

    private BridgeMethodResolver() {
    }

    public static Method findBridgedMethod(Method method) {
        if (!method.isBridge()) {
            return method;
        }
        Method method3 = cache.get(method);
        if (method3 == null) {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            ReflectionUtils.MethodFilter methodFilter = method2 -> BridgeMethodResolver.isBridgedCandidateFor(method2, method);
            ReflectionUtils.doWithMethods(method.getDeclaringClass(), arrayList::add, methodFilter);
            if (!arrayList.isEmpty()) {
                Method method4 = method3 = arrayList.size() == 1 ? (Method)arrayList.get(0) : BridgeMethodResolver.searchCandidates(arrayList, method);
            }
            if (method3 == null) {
                method3 = method;
            }
            cache.put(method, method3);
        }
        return method3;
    }

    private static boolean isBridgedCandidateFor(Method method, Method method2) {
        return !method.isBridge() && !method.equals(method2) && method.getName().equals(method2.getName()) && method.getParameterCount() == method2.getParameterCount();
    }

    @Nullable
    private static Method searchCandidates(List<Method> list, Method method) {
        if (list.isEmpty()) {
            return null;
        }
        Method method2 = null;
        boolean bl = true;
        for (Method method3 : list) {
            if (BridgeMethodResolver.isBridgeMethodFor(method, method3, method.getDeclaringClass())) {
                return method3;
            }
            if (method2 != null) {
                bl = bl && Arrays.equals(method3.getGenericParameterTypes(), method2.getGenericParameterTypes());
            }
            method2 = method3;
        }
        return bl ? list.get(0) : null;
    }

    static boolean isBridgeMethodFor(Method method, Method method2, Class<?> clazz) {
        if (BridgeMethodResolver.isResolvedTypeMatch(method2, method, clazz)) {
            return true;
        }
        Method method3 = BridgeMethodResolver.findGenericDeclaration(method);
        return method3 != null && BridgeMethodResolver.isResolvedTypeMatch(method3, method2, clazz);
    }

    private static boolean isResolvedTypeMatch(Method method, Method method2, Class<?> clazz) {
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != method2.getParameterCount()) {
            return false;
        }
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter(method, i, clazz);
            Class<?> clazz2 = classArray[i];
            if (clazz2.isArray() && !clazz2.getComponentType().equals(resolvableType.getComponentType().toClass())) {
                return false;
            }
            if (clazz2.equals(resolvableType.toClass())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Method findGenericDeclaration(Method method) {
        Object object;
        for (Class<?> clazz = method.getDeclaringClass().getSuperclass(); clazz != null && Object.class != clazz; clazz = clazz.getSuperclass()) {
            object = BridgeMethodResolver.searchForMatch(clazz, method);
            if (object == null || ((Method)object).isBridge()) continue;
            return object;
        }
        object = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        return BridgeMethodResolver.searchInterfaces(object, method);
    }

    @Nullable
    private static Method searchInterfaces(Class<?>[] classArray, Method method) {
        for (Class<?> clazz : classArray) {
            Method method2 = BridgeMethodResolver.searchForMatch(clazz, method);
            if (method2 != null && !method2.isBridge()) {
                return method2;
            }
            method2 = BridgeMethodResolver.searchInterfaces(clazz.getInterfaces(), method);
            if (method2 == null) continue;
            return method2;
        }
        return null;
    }

    @Nullable
    private static Method searchForMatch(Class<?> clazz, Method method) {
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean isVisibilityBridgeMethodPair(Method method, Method method2) {
        if (method == method2) {
            return true;
        }
        return method.getReturnType().equals(method2.getReturnType()) && method.getParameterCount() == method2.getParameterCount() && Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }
}

