/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

class ParallelSorterEmitter
extends ClassEmitter {
    private static final Type PARALLEL_SORTER = TypeUtils.parseType("org.springframework.cglib.util.ParallelSorter");
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", PARALLEL_SORTER, new Type[]{Constants.TYPE_OBJECT_ARRAY});
    private static final Signature SWAP = TypeUtils.parseSignature("void swap(int, int)");

    public ParallelSorterEmitter(ClassVisitor classVisitor, String string, Object[] objectArray) {
        super(classVisitor);
        this.begin_class(52, 1, string, PARALLEL_SORTER, null, "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.generateConstructor(objectArray);
        this.generateSwap(objectArray);
        this.end_class();
    }

    private String getFieldName(int n) {
        return "FIELD_" + n;
    }

    private void generateConstructor(Object[] objectArray) {
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_OBJECT_ARRAY, null);
        codeEmitter.load_this();
        codeEmitter.super_invoke_constructor();
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.super_putfield("a", Constants.TYPE_OBJECT_ARRAY);
        for (int i = 0; i < objectArray.length; ++i) {
            Type type = Type.getType(objectArray[i].getClass());
            this.declare_field(2, this.getFieldName(i), type, null);
            codeEmitter.load_this();
            codeEmitter.load_arg(0);
            codeEmitter.push(i);
            codeEmitter.aaload();
            codeEmitter.checkcast(type);
            codeEmitter.putfield(this.getFieldName(i));
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void generateSwap(Object[] objectArray) {
        CodeEmitter codeEmitter = this.begin_method(1, SWAP, null);
        for (int i = 0; i < objectArray.length; ++i) {
            Type type = Type.getType(objectArray[i].getClass());
            Type type2 = TypeUtils.getComponentType(type);
            Local local = codeEmitter.make_local(type);
            codeEmitter.load_this();
            codeEmitter.getfield(this.getFieldName(i));
            codeEmitter.store_local(local);
            codeEmitter.load_local(local);
            codeEmitter.load_arg(0);
            codeEmitter.load_local(local);
            codeEmitter.load_arg(1);
            codeEmitter.array_load(type2);
            codeEmitter.load_local(local);
            codeEmitter.load_arg(1);
            codeEmitter.load_local(local);
            codeEmitter.load_arg(0);
            codeEmitter.array_load(type2);
            codeEmitter.array_store(type2);
            codeEmitter.array_store(type2);
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }
}

