/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ProcessSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class FieldProviderTransformer
extends ClassEmitterTransformer {
    private static final String FIELD_NAMES = "CGLIB$FIELD_NAMES";
    private static final String FIELD_TYPES = "CGLIB$FIELD_TYPES";
    private static final Type FIELD_PROVIDER = TypeUtils.parseType("org.springframework.cglib.transform.impl.FieldProvider");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Signature PROVIDER_GET = TypeUtils.parseSignature("Object getField(String)");
    private static final Signature PROVIDER_SET = TypeUtils.parseSignature("void setField(String, Object)");
    private static final Signature PROVIDER_SET_BY_INDEX = TypeUtils.parseSignature("void setField(int, Object)");
    private static final Signature PROVIDER_GET_BY_INDEX = TypeUtils.parseSignature("Object getField(int)");
    private static final Signature PROVIDER_GET_TYPES = TypeUtils.parseSignature("Class[] getFieldTypes()");
    private static final Signature PROVIDER_GET_NAMES = TypeUtils.parseSignature("String[] getFieldNames()");
    private int access;
    private Map fields;

    @Override
    public void begin_class(int n, int n2, String string, Type type, Type[] typeArray, String string2) {
        if (!TypeUtils.isAbstract(n2)) {
            typeArray = TypeUtils.add(typeArray, FIELD_PROVIDER);
        }
        this.access = n2;
        this.fields = new HashMap();
        super.begin_class(n, n2, string, type, typeArray, string2);
    }

    @Override
    public void declare_field(int n, String string, Type type, Object object) {
        super.declare_field(n, string, type, object);
        if (!TypeUtils.isStatic(n)) {
            this.fields.put(string, type);
        }
    }

    @Override
    public void end_class() {
        if (!TypeUtils.isInterface(this.access)) {
            try {
                this.generate();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new CodeGenerationException(exception);
            }
        }
        super.end_class();
    }

    private void generate() throws Exception {
        String[] stringArray = this.fields.keySet().toArray(new String[this.fields.size()]);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        super.declare_field(26, FIELD_NAMES, Constants.TYPE_STRING_ARRAY, null);
        super.declare_field(26, FIELD_TYPES, Constants.TYPE_CLASS_ARRAY, null);
        this.initFieldProvider(stringArray);
        this.getNames();
        this.getTypes();
        this.getField(stringArray);
        this.setField(stringArray);
        this.setByIndex(stringArray, nArray);
        this.getByIndex(stringArray, nArray);
    }

    private void initFieldProvider(String[] stringArray) {
        CodeEmitter codeEmitter = this.getStaticHook();
        EmitUtils.push_object(codeEmitter, stringArray);
        codeEmitter.putstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        codeEmitter.push(stringArray.length);
        codeEmitter.newarray(Constants.TYPE_CLASS);
        codeEmitter.dup();
        for (int i = 0; i < stringArray.length; ++i) {
            codeEmitter.dup();
            codeEmitter.push(i);
            Type type = (Type)this.fields.get(stringArray[i]);
            EmitUtils.load_class(codeEmitter, type);
            codeEmitter.aastore();
        }
        codeEmitter.putstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
    }

    private void getNames() {
        CodeEmitter codeEmitter = super.begin_method(1, PROVIDER_GET_NAMES, null);
        codeEmitter.getstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void getTypes() {
        CodeEmitter codeEmitter = super.begin_method(1, PROVIDER_GET_TYPES, null);
        codeEmitter.getstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void setByIndex(final String[] stringArray, int[] nArray) throws Exception {
        final CodeEmitter codeEmitter = super.begin_method(1, PROVIDER_SET_BY_INDEX, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(1);
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            @Override
            public void processCase(int n, Label label) throws Exception {
                Type type = (Type)FieldProviderTransformer.this.fields.get(stringArray[n]);
                codeEmitter.unbox(type);
                codeEmitter.putfield(stringArray[n]);
                codeEmitter.return_value();
            }

            @Override
            public void processDefault() throws Exception {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        codeEmitter.end_method();
    }

    private void getByIndex(final String[] stringArray, int[] nArray) throws Exception {
        final CodeEmitter codeEmitter = super.begin_method(1, PROVIDER_GET_BY_INDEX, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            @Override
            public void processCase(int n, Label label) throws Exception {
                Type type = (Type)FieldProviderTransformer.this.fields.get(stringArray[n]);
                codeEmitter.getfield(stringArray[n]);
                codeEmitter.box(type);
                codeEmitter.return_value();
            }

            @Override
            public void processDefault() throws Exception {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        codeEmitter.end_method();
    }

    private void getField(String[] stringArray) throws Exception {
        final CodeEmitter codeEmitter = this.begin_method(1, PROVIDER_GET, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        EmitUtils.string_switch(codeEmitter, stringArray, 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object object, Label label) {
                Type type = (Type)FieldProviderTransformer.this.fields.get(object);
                codeEmitter.getfield((String)object);
                codeEmitter.box(type);
                codeEmitter.return_value();
            }

            @Override
            public void processDefault() {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        codeEmitter.end_method();
    }

    private void setField(String[] stringArray) throws Exception {
        final CodeEmitter codeEmitter = this.begin_method(1, PROVIDER_SET, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(1);
        codeEmitter.load_arg(0);
        EmitUtils.string_switch(codeEmitter, stringArray, 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object object, Label label) {
                Type type = (Type)FieldProviderTransformer.this.fields.get(object);
                codeEmitter.unbox(type);
                codeEmitter.putfield((String)object);
                codeEmitter.return_value();
            }

            @Override
            public void processDefault() {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        codeEmitter.end_method();
    }
}

