/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.reflect;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public abstract class MethodDelegate {
    private static final MethodDelegateKey KEY_FACTORY = (MethodDelegateKey)((Object)KeyFactory.create(MethodDelegateKey.class, KeyFactory.CLASS_BY_NAME));
    protected Object target;
    protected String eqMethod;

    public static MethodDelegate createStatic(Class clazz, String string, Class clazz2) {
        Generator generator = new Generator();
        generator.setTargetClass(clazz);
        generator.setMethodName(string);
        generator.setInterface(clazz2);
        return generator.create();
    }

    public static MethodDelegate create(Object object, String string, Class clazz) {
        Generator generator = new Generator();
        generator.setTarget(object);
        generator.setMethodName(string);
        generator.setInterface(clazz);
        return generator.create();
    }

    public boolean equals(Object object) {
        MethodDelegate methodDelegate = (MethodDelegate)object;
        return methodDelegate != null && this.target == methodDelegate.target && this.eqMethod.equals(methodDelegate.eqMethod);
    }

    public int hashCode() {
        return this.target.hashCode() ^ this.eqMethod.hashCode();
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract MethodDelegate newInstance(Object var1);

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(MethodDelegate.class.getName());
        private static final Type METHOD_DELEGATE = TypeUtils.parseType("org.springframework.cglib.reflect.MethodDelegate");
        private static final Signature NEW_INSTANCE = new Signature("newInstance", METHOD_DELEGATE, new Type[]{Constants.TYPE_OBJECT});
        private Object target;
        private Class targetClass;
        private String methodName;
        private Class iface;

        public Generator() {
            super(SOURCE);
        }

        public void setTarget(Object object) {
            this.target = object;
            this.targetClass = object.getClass();
        }

        public void setTargetClass(Class clazz) {
            this.targetClass = clazz;
        }

        public void setMethodName(String string) {
            this.methodName = string;
        }

        public void setInterface(Class clazz) {
            this.iface = clazz;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.targetClass);
        }

        public MethodDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            Object object = KEY_FACTORY.newInstance(this.targetClass, this.methodName, this.iface);
            return (MethodDelegate)super.create(object);
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ((MethodDelegate)ReflectUtils.newInstance(clazz)).newInstance(this.target);
        }

        @Override
        protected Object nextInstance(Object object) {
            return ((MethodDelegate)object).newInstance(this.target);
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws NoSuchMethodException {
            MethodInfo methodInfo;
            boolean bl;
            Method method = ReflectUtils.findInterfaceMethod(this.iface);
            Method method2 = this.targetClass.getMethod(this.methodName, method.getParameterTypes());
            if (!method.getReturnType().isAssignableFrom(method2.getReturnType())) {
                throw new IllegalArgumentException("incompatible return types");
            }
            if (this.target == null ^ (bl = TypeUtils.isStatic((methodInfo = ReflectUtils.getMethodInfo(method2)).getModifiers()))) {
                throw new IllegalArgumentException("Static method " + (bl ? "not " : "") + "expected");
            }
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(52, 1, this.getClassName(), METHOD_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            classEmitter.declare_field(26, "eqMethod", Constants.TYPE_STRING, null);
            EmitUtils.null_constructor(classEmitter);
            MethodInfo methodInfo2 = ReflectUtils.getMethodInfo(this.iface.getDeclaredMethods()[0]);
            int n = 1;
            if ((methodInfo2.getModifiers() & 0x80) == 128) {
                n |= 0x80;
            }
            CodeEmitter codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo2, n);
            codeEmitter.load_this();
            codeEmitter.super_getfield("target", Constants.TYPE_OBJECT);
            codeEmitter.checkcast(methodInfo.getClassInfo().getType());
            codeEmitter.load_args();
            codeEmitter.invoke(methodInfo);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(1, NEW_INSTANCE, null);
            codeEmitter.new_instance_this();
            codeEmitter.dup();
            codeEmitter.dup2();
            codeEmitter.invoke_constructor_this();
            codeEmitter.getfield("eqMethod");
            codeEmitter.super_putfield("eqMethod", Constants.TYPE_STRING);
            codeEmitter.load_arg(0);
            codeEmitter.super_putfield("target", Constants.TYPE_OBJECT);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_static();
            codeEmitter.push(methodInfo.getSignature().toString());
            codeEmitter.putfield("eqMethod");
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.end_class();
        }
    }

    static interface MethodDelegateKey {
        public Object newInstance(Class var1, String var2, Class var3);
    }
}

