/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.proxy.MethodInterceptorGenerator;
import org.springframework.cglib.reflect.FastClass;

public class MethodProxy {
    private Signature sig1;
    private Signature sig2;
    private CreateInfo createInfo;
    private final Object initLock = new Object();
    private volatile FastClassInfo fastClassInfo;

    public static MethodProxy create(Class clazz, Class clazz2, String string, String string2, String string3) {
        MethodProxy methodProxy = new MethodProxy();
        methodProxy.sig1 = new Signature(string2, string);
        methodProxy.sig2 = new Signature(string3, string);
        methodProxy.createInfo = new CreateInfo(clazz, clazz2);
        return methodProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.fastClassInfo == null) {
            Object object = this.initLock;
            synchronized (object) {
                if (this.fastClassInfo == null) {
                    CreateInfo createInfo = this.createInfo;
                    FastClassInfo fastClassInfo = new FastClassInfo();
                    fastClassInfo.f1 = MethodProxy.helper(createInfo, createInfo.c1);
                    fastClassInfo.f2 = MethodProxy.helper(createInfo, createInfo.c2);
                    fastClassInfo.i1 = fastClassInfo.f1.getIndex(this.sig1);
                    fastClassInfo.i2 = fastClassInfo.f2.getIndex(this.sig2);
                    this.fastClassInfo = fastClassInfo;
                    this.createInfo = null;
                }
            }
        }
    }

    private static FastClass helper(CreateInfo createInfo, Class clazz) {
        FastClass.Generator generator = new FastClass.Generator();
        generator.setType(clazz);
        generator.setContextClass(clazz);
        generator.setClassLoader(createInfo.c2.getClassLoader());
        generator.setNamingPolicy(createInfo.namingPolicy);
        generator.setStrategy(createInfo.strategy);
        generator.setAttemptLoad(createInfo.attemptLoad);
        return generator.create();
    }

    private MethodProxy() {
    }

    public Signature getSignature() {
        return this.sig1;
    }

    public String getSuperName() {
        return this.sig2.getName();
    }

    public int getSuperIndex() {
        this.init();
        return this.fastClassInfo.i2;
    }

    FastClass getFastClass() {
        this.init();
        return this.fastClassInfo.f1;
    }

    FastClass getSuperFastClass() {
        this.init();
        return this.fastClassInfo.f2;
    }

    public static MethodProxy find(Class clazz, Signature signature) {
        try {
            Method method = clazz.getDeclaredMethod("CGLIB$findMethodProxy", MethodInterceptorGenerator.FIND_PROXY_TYPES);
            return (MethodProxy)method.invoke(null, signature);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Class " + clazz + " does not use a MethodInterceptor");
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new CodeGenerationException(reflectiveOperationException);
        }
    }

    public Object invoke(Object object, Object[] objectArray) throws Throwable {
        try {
            this.init();
            FastClassInfo fastClassInfo = this.fastClassInfo;
            return fastClassInfo.f1.invoke(fastClassInfo.i1, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.fastClassInfo.i1 < 0) {
                throw new IllegalArgumentException("Protected method: " + this.sig1);
            }
            throw illegalArgumentException;
        }
    }

    public Object invokeSuper(Object object, Object[] objectArray) throws Throwable {
        try {
            this.init();
            FastClassInfo fastClassInfo = this.fastClassInfo;
            return fastClassInfo.f2.invoke(fastClassInfo.i2, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    private static class CreateInfo {
        Class c1;
        Class c2;
        NamingPolicy namingPolicy;
        GeneratorStrategy strategy;
        boolean attemptLoad;

        public CreateInfo(Class clazz, Class clazz2) {
            this.c1 = clazz;
            this.c2 = clazz2;
            AbstractClassGenerator abstractClassGenerator = AbstractClassGenerator.getCurrent();
            if (abstractClassGenerator != null) {
                this.namingPolicy = abstractClassGenerator.getNamingPolicy();
                this.strategy = abstractClassGenerator.getStrategy();
                this.attemptLoad = abstractClassGenerator.getAttemptLoad();
            }
        }
    }

    private static class FastClassInfo {
        FastClass f1;
        FastClass f2;
        int i1;
        int i2;

        private FastClassInfo() {
        }
    }
}

