/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.springframework.cglib.core.internal.Function;

public class LoadingCache<K, KK, V> {
    protected final ConcurrentMap<KK, Object> map;
    protected final Function<K, V> loader;
    protected final Function<K, KK> keyMapper;
    public static final Function IDENTITY = new Function(){

        public Object apply(Object object) {
            return object;
        }
    };

    public LoadingCache(Function<K, KK> function, Function<K, V> function2) {
        this.keyMapper = function;
        this.loader = function2;
        this.map = new ConcurrentHashMap<KK, Object>();
    }

    public static <K> Function<K, K> identity() {
        return IDENTITY;
    }

    public V get(K k) {
        KK KK = this.keyMapper.apply(k);
        Object v = this.map.get(KK);
        if (v != null && !(v instanceof FutureTask)) {
            return v;
        }
        return this.createEntry(k, KK, v);
    }

    protected V createEntry(final K k, KK KK, Object object) {
        Object object2;
        FutureTask futureTask;
        boolean bl = false;
        if (object != null) {
            futureTask = (FutureTask)object;
        } else {
            futureTask = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return LoadingCache.this.loader.apply(k);
                }
            });
            object2 = this.map.putIfAbsent(KK, futureTask);
            if (object2 == null) {
                bl = true;
                futureTask.run();
            } else if (object2 instanceof FutureTask) {
                futureTask = (FutureTask)object2;
            } else {
                return object2;
            }
        }
        try {
            object2 = futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Interrupted while loading cache item", interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException("Unable to load cache item", throwable);
        }
        if (bl) {
            this.map.put(KK, object2);
        }
        return object2;
    }
}

