/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Customizer;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.FieldTypeCustomizer;
import org.springframework.cglib.core.HashCodeCustomizer;
import org.springframework.cglib.core.KeyFactoryCustomizer;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.core.internal.CustomizerRegistry;

public abstract class KeyFactory {
    private static final Signature GET_NAME = TypeUtils.parseSignature("String getName()");
    private static final Signature GET_CLASS = TypeUtils.parseSignature("Class getClass()");
    private static final Signature HASH_CODE = TypeUtils.parseSignature("int hashCode()");
    private static final Signature EQUALS = TypeUtils.parseSignature("boolean equals(Object)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature APPEND_STRING = TypeUtils.parseSignature("StringBuffer append(String)");
    private static final Type KEY_FACTORY = TypeUtils.parseType("org.springframework.cglib.core.KeyFactory");
    private static final Signature GET_SORT = TypeUtils.parseSignature("int getSort()");
    private static final int[] PRIMES = new int[]{11, 73, 179, 331, 521, 787, 1213, 1823, 2609, 3691, 5189, 7247, 10037, 13931, 19289, 26627, 36683, 50441, 69403, 95401, 131129, 180179, 247501, 340057, 467063, 641371, 880603, 1209107, 1660097, 2279161, 3129011, 4295723, 5897291, 8095873, 11114263, 15257791, 20946017, 28754629, 39474179, 54189869, 74391461, 102123817, 140194277, 192456917, 264202273, 362693231, 497900099, 683510293, 938313161, 1288102441, 1768288259};
    public static final Customizer CLASS_BY_NAME = new Customizer(){

        @Override
        public void customize(CodeEmitter codeEmitter, Type type) {
            if (type.equals(Constants.TYPE_CLASS)) {
                codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
            }
        }
    };
    public static final FieldTypeCustomizer STORE_CLASS_AS_STRING = new FieldTypeCustomizer(){

        @Override
        public void customize(CodeEmitter codeEmitter, int n, Type type) {
            if (type.equals(Constants.TYPE_CLASS)) {
                codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
            }
        }

        @Override
        public Type getOutType(int n, Type type) {
            if (type.equals(Constants.TYPE_CLASS)) {
                return Constants.TYPE_STRING;
            }
            return type;
        }
    };
    public static final HashCodeCustomizer HASH_ASM_TYPE = new HashCodeCustomizer(){

        @Override
        public boolean customize(CodeEmitter codeEmitter, Type type) {
            if (Constants.TYPE_TYPE.equals(type)) {
                codeEmitter.invoke_virtual(type, GET_SORT);
                return true;
            }
            return false;
        }
    };
    @Deprecated
    public static final Customizer OBJECT_BY_CLASS = new Customizer(){

        @Override
        public void customize(CodeEmitter codeEmitter, Type type) {
            codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, GET_CLASS);
        }
    };

    protected KeyFactory() {
    }

    public static KeyFactory create(Class clazz) {
        return KeyFactory.create(clazz, null);
    }

    public static KeyFactory create(Class clazz, Customizer customizer) {
        return KeyFactory.create(clazz.getClassLoader(), clazz, customizer);
    }

    public static KeyFactory create(Class clazz, KeyFactoryCustomizer keyFactoryCustomizer, List<KeyFactoryCustomizer> list) {
        return KeyFactory.create(clazz.getClassLoader(), clazz, keyFactoryCustomizer, list);
    }

    public static KeyFactory create(ClassLoader classLoader, Class clazz, Customizer customizer) {
        return KeyFactory.create(classLoader, clazz, customizer, Collections.emptyList());
    }

    public static KeyFactory create(ClassLoader classLoader, Class clazz, KeyFactoryCustomizer keyFactoryCustomizer, List<KeyFactoryCustomizer> list) {
        Generator generator = new Generator();
        generator.setInterface(clazz);
        generator.setContextClass(clazz);
        if (keyFactoryCustomizer != null) {
            generator.addCustomizer(keyFactoryCustomizer);
        }
        if (list != null && !list.isEmpty()) {
            for (KeyFactoryCustomizer keyFactoryCustomizer2 : list) {
                generator.addCustomizer(keyFactoryCustomizer2);
            }
        }
        generator.setClassLoader(classLoader);
        return generator.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(KeyFactory.class.getName());
        private static final Class[] KNOWN_CUSTOMIZER_TYPES = new Class[]{Customizer.class, FieldTypeCustomizer.class};
        private Class keyInterface;
        private CustomizerRegistry customizers = new CustomizerRegistry(KNOWN_CUSTOMIZER_TYPES);
        private int constant;
        private int multiplier;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.keyInterface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.keyInterface);
        }

        @Deprecated
        public void setCustomizer(Customizer customizer) {
            this.customizers = CustomizerRegistry.singleton(customizer);
        }

        public void addCustomizer(KeyFactoryCustomizer keyFactoryCustomizer) {
            this.customizers.add(keyFactoryCustomizer);
        }

        public <T> List<T> getCustomizers(Class<T> clazz) {
            return this.customizers.get(clazz);
        }

        public void setInterface(Class clazz) {
            this.keyInterface = clazz;
        }

        public KeyFactory create() {
            this.setNamePrefix(this.keyInterface.getName());
            return (KeyFactory)super.create(this.keyInterface.getName());
        }

        public void setHashConstant(int n) {
            this.constant = n;
        }

        public void setHashMultiplier(int n) {
            this.multiplier = n;
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ReflectUtils.newInstance(clazz);
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            int n;
            int n2;
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            Method method = ReflectUtils.findNewInstance(this.keyInterface);
            if (!method.getReturnType().equals(Object.class)) {
                throw new IllegalArgumentException("newInstance method must return Object");
            }
            Type[] typeArray = TypeUtils.getTypes(method.getParameterTypes());
            classEmitter.begin_class(52, 1, this.getClassName(), KEY_FACTORY, new Type[]{Type.getType(this.keyInterface)}, "<generated>");
            EmitUtils.null_constructor(classEmitter);
            EmitUtils.factory_method(classEmitter, ReflectUtils.getSignature(method));
            int n3 = 0;
            CodeEmitter codeEmitter = classEmitter.begin_method(1, TypeUtils.parseConstructor(typeArray), null);
            codeEmitter.load_this();
            codeEmitter.super_invoke_constructor();
            codeEmitter.load_this();
            List<FieldTypeCustomizer> list = this.getCustomizers(FieldTypeCustomizer.class);
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                Type type;
                Type type2 = type = typeArray[n2];
                for (FieldTypeCustomizer fieldTypeCustomizer : list) {
                    type2 = fieldTypeCustomizer.getOutType(n2, type2);
                }
                n3 += type2.hashCode();
                classEmitter.declare_field(18, this.getFieldName(n2), type2, null);
                codeEmitter.dup();
                codeEmitter.load_arg(n2);
                for (FieldTypeCustomizer fieldTypeCustomizer : list) {
                    fieldTypeCustomizer.customize(codeEmitter, n2, type);
                }
                codeEmitter.putfield(this.getFieldName(n2));
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(1, HASH_CODE, null);
            n2 = this.constant != 0 ? this.constant : PRIMES[Math.abs(n3) % PRIMES.length];
            int n4 = this.multiplier != 0 ? this.multiplier : PRIMES[Math.abs(n3 * 13) % PRIMES.length];
            codeEmitter.push(n2);
            for (int i = 0; i < typeArray.length; ++i) {
                codeEmitter.load_this();
                codeEmitter.getfield(this.getFieldName(i));
                EmitUtils.hash_code(codeEmitter, typeArray[i], n4, this.customizers);
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(1, EQUALS, null);
            Label label = codeEmitter.make_label();
            codeEmitter.load_arg(0);
            codeEmitter.instance_of_this();
            codeEmitter.if_jump(153, label);
            for (n = 0; n < typeArray.length; ++n) {
                codeEmitter.load_this();
                codeEmitter.getfield(this.getFieldName(n));
                codeEmitter.load_arg(0);
                codeEmitter.checkcast_this();
                codeEmitter.getfield(this.getFieldName(n));
                EmitUtils.not_equals(codeEmitter, typeArray[n], label, this.customizers);
            }
            codeEmitter.push(1);
            codeEmitter.return_value();
            codeEmitter.mark(label);
            codeEmitter.push(0);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(1, TO_STRING, null);
            codeEmitter.new_instance(Constants.TYPE_STRING_BUFFER);
            codeEmitter.dup();
            codeEmitter.invoke_constructor(Constants.TYPE_STRING_BUFFER);
            for (n = 0; n < typeArray.length; ++n) {
                if (n > 0) {
                    codeEmitter.push(", ");
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
                }
                codeEmitter.load_this();
                codeEmitter.getfield(this.getFieldName(n));
                EmitUtils.append_string(codeEmitter, typeArray[n], EmitUtils.DEFAULT_DELIMITERS, this.customizers);
            }
            codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, TO_STRING);
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.end_class();
        }

        private String getFieldName(int n) {
            return "FIELD_" + n;
        }
    }
}

