/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;

public class DebuggingClassWriter
extends ClassVisitor {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static Constructor traceCtor;
    private String className;
    private String superName;

    public DebuggingClassWriter(int n) {
        super(Constants.ASM_API, new ClassWriter(n));
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.className = string.replace('/', '.');
        this.superName = string3.replace('/', '.');
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                byte[] byArray;
                block10: {
                    byArray = ((ClassWriter)DebuggingClassWriter.this.cv).toByteArray();
                    if (debugLocation != null) {
                        String string = DebuggingClassWriter.this.className.replace('.', File.separatorChar);
                        try {
                            new File(debugLocation + File.separatorChar + string).getParentFile().mkdirs();
                            File file = new File(new File(debugLocation), string + ".class");
                            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                                ((OutputStream)bufferedOutputStream).write(byArray);
                            }
                            if (traceCtor == null) break block10;
                            file = new File(new File(debugLocation), string + ".asm");
                            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ClassReader classReader = new ClassReader(byArray);
                                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(bufferedOutputStream));
                                ClassVisitor classVisitor = (ClassVisitor)traceCtor.newInstance(null, printWriter);
                                classReader.accept(classVisitor, 0);
                                printWriter.flush();
                            }
                            finally {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                        }
                        catch (Exception exception) {
                            throw new CodeGenerationException(exception);
                        }
                    }
                }
                return byArray;
            }
        });
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class<?> clazz = Class.forName("org.springframework.asm.util.TraceClassVisitor");
                traceCtor = clazz.getConstructor(ClassVisitor.class, PrintWriter.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

