/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection collection, Transformer transformer) {
        HashMap hashMap = new HashMap();
        for (Object e : collection) {
            Object object = transformer.transform(e);
            LinkedList linkedList = (LinkedList)hashMap.get(object);
            if (linkedList == null) {
                linkedList = new LinkedList();
                hashMap.put(object, linkedList);
            }
            linkedList.add(e);
        }
        return hashMap;
    }

    public static void reverse(Map map, Map map2) {
        for (Object k : map.keySet()) {
            map2.put(map.get(k), k);
        }
    }

    public static Collection filter(Collection collection, Predicate predicate) {
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            if (predicate.evaluate(iterator2.next())) continue;
            iterator2.remove();
        }
        return collection;
    }

    public static List transform(Collection collection, Transformer transformer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(transformer.transform(iterator2.next()));
        }
        return arrayList;
    }

    public static Map getIndexMap(List list) {
        HashMap hashMap = new HashMap();
        int n = 0;
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            hashMap.put(iterator2.next(), new Integer(n++));
        }
        return hashMap;
    }
}

