/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int currentNumberOfBytes;

    public CircularByteBuffer(int n) {
        this.buffer = IOUtils.byteArray(n);
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public CircularByteBuffer() {
        this(8192);
    }

    public byte read() {
        if (this.currentNumberOfBytes <= 0) {
            throw new IllegalStateException("No bytes available.");
        }
        byte by = this.buffer[this.startOffset];
        --this.currentNumberOfBytes;
        if (++this.startOffset == this.buffer.length) {
            this.startOffset = 0;
        }
        return by;
    }

    public void read(byte[] byArray, int n, int n2) {
        Objects.requireNonNull(byArray, "targetBuffer");
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0 || n2 > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("The supplied byte array contains only " + byArray.length + " bytes, but offset, and length would require " + (n + n2 - 1));
        }
        if (this.currentNumberOfBytes < n2) {
            throw new IllegalStateException("Currently, there are only " + this.currentNumberOfBytes + "in the buffer, not " + n2);
        }
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            byArray[n3++] = this.buffer[this.startOffset];
            --this.currentNumberOfBytes;
            if (++this.startOffset != this.buffer.length) continue;
            this.startOffset = 0;
        }
    }

    public void add(byte by) {
        if (this.currentNumberOfBytes >= this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        this.buffer[this.endOffset] = by;
        ++this.currentNumberOfBytes;
        if (++this.endOffset == this.buffer.length) {
            this.endOffset = 0;
        }
    }

    public boolean peek(byte[] byArray, int n, int n2) {
        Objects.requireNonNull(byArray, "Buffer");
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0 || n2 > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (n2 < this.currentNumberOfBytes) {
            return false;
        }
        int n3 = this.startOffset;
        for (int i = 0; i < n2; ++i) {
            if (this.buffer[n3] != byArray[i + n]) {
                return false;
            }
            if (++n3 != this.buffer.length) continue;
            n3 = 0;
        }
        return true;
    }

    public void add(byte[] byArray, int n, int n2) {
        Objects.requireNonNull(byArray, "Buffer");
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        if (this.currentNumberOfBytes + n2 > this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        for (int i = 0; i < n2; ++i) {
            this.buffer[this.endOffset] = byArray[n + i];
            if (++this.endOffset != this.buffer.length) continue;
            this.endOffset = 0;
        }
        this.currentNumberOfBytes += n2;
    }

    public boolean hasSpace() {
        return this.currentNumberOfBytes < this.buffer.length;
    }

    public boolean hasSpace(int n) {
        return this.currentNumberOfBytes + n <= this.buffer.length;
    }

    public boolean hasBytes() {
        return this.currentNumberOfBytes > 0;
    }

    public int getSpace() {
        return this.buffer.length - this.currentNumberOfBytes;
    }

    public int getCurrentNumberOfBytes() {
        return this.currentNumberOfBytes;
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }
}

