/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.util.Objects;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    public UnsynchronizedByteArrayInputStream(byte[] byArray) {
        this.data = Objects.requireNonNull(byArray, "data");
        this.offset = 0;
        this.eod = byArray.length;
        this.markedOffset = this.offset;
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n) {
        Objects.requireNonNull(byArray, "data");
        if (n < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        this.data = byArray;
        this.offset = Math.min(n, byArray.length > 0 ? byArray.length : n);
        this.eod = byArray.length;
        this.markedOffset = this.offset;
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        this.data = Objects.requireNonNull(byArray, "data");
        this.offset = Math.min(n, byArray.length > 0 ? byArray.length : n);
        this.eod = Math.min(this.offset + n2, byArray.length);
        this.markedOffset = this.offset;
    }

    @Override
    public int available() {
        return this.offset < this.eod ? this.eod - this.offset : 0;
    }

    @Override
    public int read() {
        return this.offset < this.eod ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray) {
        Objects.requireNonNull(byArray, "dest");
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        Objects.requireNonNull(byArray, "dest");
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int n3 = this.eod - this.offset;
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, byArray, n, n3);
        this.offset += n3;
        return n3;
    }

    @Override
    public long skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long l2 = this.eod - this.offset;
        if (l < l2) {
            l2 = l;
        }
        this.offset = (int)((long)this.offset + l2);
        return l2;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.markedOffset = this.offset;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }
}

