/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] CSZ = new char[]{'C', 'S', 'Z'};
    private static final char[] FPVW = new char[]{'F', 'P', 'V', 'W'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHKOQUX = new char[]{'A', 'H', 'K', 'O', 'Q', 'U', 'X'};
    private static final char[] DTX = new char[]{'D', 'T', 'X'};
    private static final char CHAR_IGNORE = '-';

    private static boolean arrayContains(char[] cArray, char c) {
        for (char c2 : cArray) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String string) {
        if (string == null) {
            return null;
        }
        CologneInputBuffer cologneInputBuffer = new CologneInputBuffer(this.preprocess(string));
        CologneOutputBuffer cologneOutputBuffer = new CologneOutputBuffer(cologneInputBuffer.length() * 2);
        char c = '-';
        while (cologneInputBuffer.length() > 0) {
            char c2 = cologneInputBuffer.removeNext();
            char c3 = cologneInputBuffer.length() > 0 ? (char)cologneInputBuffer.getNextChar() : (char)'-';
            if (c2 < 'A' || c2 > 'Z') continue;
            if (ColognePhonetic.arrayContains(AEIJOUY, c2)) {
                cologneOutputBuffer.put('0');
            } else if (c2 == 'B' || c2 == 'P' && c3 != 'H') {
                cologneOutputBuffer.put('1');
            } else if (!(c2 != 'D' && c2 != 'T' || ColognePhonetic.arrayContains(CSZ, c3))) {
                cologneOutputBuffer.put('2');
            } else if (ColognePhonetic.arrayContains(FPVW, c2)) {
                cologneOutputBuffer.put('3');
            } else if (ColognePhonetic.arrayContains(GKQ, c2)) {
                cologneOutputBuffer.put('4');
            } else if (c2 == 'X' && !ColognePhonetic.arrayContains(CKQ, c)) {
                cologneOutputBuffer.put('4');
                cologneOutputBuffer.put('8');
            } else if (c2 == 'S' || c2 == 'Z') {
                cologneOutputBuffer.put('8');
            } else if (c2 == 'C') {
                if (cologneOutputBuffer.length() == 0) {
                    if (ColognePhonetic.arrayContains(AHKLOQRUX, c3)) {
                        cologneOutputBuffer.put('4');
                    } else {
                        cologneOutputBuffer.put('8');
                    }
                } else if (ColognePhonetic.arrayContains(SZ, c) || !ColognePhonetic.arrayContains(AHKOQUX, c3)) {
                    cologneOutputBuffer.put('8');
                } else {
                    cologneOutputBuffer.put('4');
                }
            } else if (ColognePhonetic.arrayContains(DTX, c2)) {
                cologneOutputBuffer.put('8');
            } else if (c2 == 'R') {
                cologneOutputBuffer.put('7');
            } else if (c2 == 'L') {
                cologneOutputBuffer.put('5');
            } else if (c2 == 'M' || c2 == 'N') {
                cologneOutputBuffer.put('6');
            } else if (c2 == 'H') {
                cologneOutputBuffer.put('-');
            }
            c = c2;
        }
        return cologneOutputBuffer.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private char[] preprocess(String string) {
        char[] cArray = string.toUpperCase(Locale.GERMAN).toCharArray();
        block5: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\u00c4': {
                    cArray[i] = 65;
                    continue block5;
                }
                case '\u00dc': {
                    cArray[i] = 85;
                    continue block5;
                }
                case '\u00d6': {
                    cArray[i] = 79;
                    continue block5;
                }
            }
        }
        return cArray;
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        public CologneInputBuffer(char[] cArray) {
            super(cArray);
        }

        @Override
        protected char[] copyData(int n, int n2) {
            char[] cArray = new char[n2];
            System.arraycopy(this.data, this.data.length - this.length + n, cArray, 0, n2);
            return cArray;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        public char removeNext() {
            char c = this.getNextChar();
            --this.length;
            return c;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        private char lastCode;

        public CologneOutputBuffer(int n) {
            super(n);
            this.lastCode = (char)47;
        }

        public void put(char c) {
            if (c != '-' && this.lastCode != c && (c != '0' || this.length == 0)) {
                this.data[this.length] = c;
                ++this.length;
            }
            this.lastCode = c;
        }

        @Override
        protected char[] copyData(int n, int n2) {
            char[] cArray = new char[n2];
            System.arraycopy(this.data, n, cArray, 0, n2);
            return cArray;
        }
    }

    private abstract class CologneBuffer {
        protected final char[] data;
        protected int length = 0;

        public CologneBuffer(char[] cArray) {
            this.data = cArray;
            this.length = cArray.length;
        }

        public CologneBuffer(int n) {
            this.data = new char[n];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

