/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;

public final class MurmurHash2 {
    private static final int M32 = 1540483477;
    private static final int R32 = 24;
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;

    private MurmurHash2() {
    }

    public static int hash32(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 ^ n;
        int n5 = n >> 2;
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = n3 << 2;
            int n7 = MurmurHash2.getLittleEndianInt(byArray, n6);
            n7 *= 1540483477;
            n7 ^= n7 >>> 24;
            n4 *= 1540483477;
            n4 ^= (n7 *= 1540483477);
        }
        n3 = n5 << 2;
        switch (n - n3) {
            case 3: {
                n4 ^= (byArray[n3 + 2] & 0xFF) << 16;
            }
            case 2: {
                n4 ^= (byArray[n3 + 1] & 0xFF) << 8;
            }
            case 1: {
                n4 ^= byArray[n3] & 0xFF;
                n4 *= 1540483477;
            }
        }
        n4 ^= n4 >>> 13;
        n4 *= 1540483477;
        n4 ^= n4 >>> 15;
        return n4;
    }

    public static int hash32(byte[] byArray, int n) {
        return MurmurHash2.hash32(byArray, n, -1756908916);
    }

    public static int hash32(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash2.hash32(byArray, byArray.length);
    }

    public static int hash32(String string, int n, int n2) {
        return MurmurHash2.hash32(string.substring(n, n + n2));
    }

    public static long hash64(byte[] byArray, int n, int n2) {
        int n3;
        long l = (long)n2 & 0xFFFFFFFFL ^ (long)n * -4132994306676758123L;
        int n4 = n >> 3;
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = n3 << 3;
            long l2 = MurmurHash2.getLittleEndianLong(byArray, n5);
            l2 *= -4132994306676758123L;
            l2 ^= l2 >>> 47;
            l ^= (l2 *= -4132994306676758123L);
            l *= -4132994306676758123L;
        }
        n3 = n4 << 3;
        switch (n - n3) {
            case 7: {
                l ^= ((long)byArray[n3 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l ^= ((long)byArray[n3 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l ^= ((long)byArray[n3 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l ^= ((long)byArray[n3 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l ^= ((long)byArray[n3 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l ^= ((long)byArray[n3 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l ^= (long)byArray[n3] & 0xFFL;
                l *= -4132994306676758123L;
            }
        }
        l ^= l >>> 47;
        l *= -4132994306676758123L;
        l ^= l >>> 47;
        return l;
    }

    public static long hash64(byte[] byArray, int n) {
        return MurmurHash2.hash64(byArray, n, -512093083);
    }

    public static long hash64(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash2.hash64(byArray, byArray.length);
    }

    public static long hash64(String string, int n, int n2) {
        return MurmurHash2.hash64(string.substring(n, n + n2));
    }

    private static int getLittleEndianInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static long getLittleEndianLong(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }
}

