/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bJ\u0015\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b#J.\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/http2/Http2;", "", "()V", "BINARY", "", "", "[Ljava/lang/String;", "CONNECTION_PREFACE", "Lokio/ByteString;", "FLAGS", "FLAG_ACK", "", "FLAG_COMPRESSED", "FLAG_END_HEADERS", "FLAG_END_PUSH_PROMISE", "FLAG_END_STREAM", "FLAG_NONE", "FLAG_PADDED", "FLAG_PRIORITY", "FRAME_NAMES", "INITIAL_MAX_FRAME_SIZE", "TYPE_CONTINUATION", "TYPE_DATA", "TYPE_GOAWAY", "TYPE_HEADERS", "TYPE_PING", "TYPE_PRIORITY", "TYPE_PUSH_PROMISE", "TYPE_RST_STREAM", "TYPE_SETTINGS", "TYPE_WINDOW_UPDATE", "formatFlags", "type", "flags", "formattedType", "formattedType$okhttp", "frameLog", "inbound", "", "streamId", "length", "okhttp"})
public final class Http2 {
    @JvmField
    @NotNull
    public static final ByteString CONNECTION_PREFACE;
    public static final int INITIAL_MAX_FRAME_SIZE = 16384;
    public static final int TYPE_DATA = 0;
    public static final int TYPE_HEADERS = 1;
    public static final int TYPE_PRIORITY = 2;
    public static final int TYPE_RST_STREAM = 3;
    public static final int TYPE_SETTINGS = 4;
    public static final int TYPE_PUSH_PROMISE = 5;
    public static final int TYPE_PING = 6;
    public static final int TYPE_GOAWAY = 7;
    public static final int TYPE_WINDOW_UPDATE = 8;
    public static final int TYPE_CONTINUATION = 9;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ACK = 1;
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_END_PUSH_PROMISE = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    public static final int FLAG_COMPRESSED = 32;
    private static final String[] FRAME_NAMES;
    private static final String[] FLAGS;
    private static final String[] BINARY;
    public static final Http2 INSTANCE;

    @NotNull
    public final String frameLog(boolean bl, int n, int n2, int n3, int n4) {
        String string = this.formattedType$okhttp(n3);
        String string2 = this.formatFlags(n3, n4);
        String string3 = bl ? "<<" : ">>";
        return Util.format("%s 0x%08x %5d %-13s %s", string3, n, n2, string, string2);
    }

    @NotNull
    public final String formattedType$okhttp(int n) {
        return n < FRAME_NAMES.length ? FRAME_NAMES[n] : Util.format("0x%02x", n);
    }

    @NotNull
    public final String formatFlags(int n, int n2) {
        String string;
        if (n2 == 0) {
            return "";
        }
        switch (n) {
            case 4: 
            case 6: {
                return n2 == 1 ? "ACK" : BINARY[n2];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return BINARY[n2];
            }
        }
        if (n2 < FLAGS.length) {
            String string2 = FLAGS[n2];
            string = string2;
            Intrinsics.checkNotNull(string2);
        } else {
            string = BINARY[n2];
        }
        String string3 = string;
        return n == 5 && (n2 & 4) != 0 ? StringsKt.replace$default(string3, "HEADERS", "PUSH_PROMISE", false, 4, null) : (n == 0 && (n2 & 0x20) != 0 ? StringsKt.replace$default(string3, "PRIORITY", "COMPRESSED", false, 4, null) : string3);
    }

    private Http2() {
    }

    static {
        int n;
        int n2;
        Http2 http2;
        INSTANCE = http2 = new Http2();
        CONNECTION_PREFACE = ByteString.Companion.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        int n3 = 256;
        Object[] objectArray = new String[n3];
        Object object = 0;
        while (object < n3) {
            String string;
            int n4 = object;
            int n5 = object++;
            String[] stringArray = objectArray;
            n2 = 0;
            Object[] objectArray2 = new Object[1];
            String string2 = Integer.toBinaryString(n4);
            Intrinsics.checkNotNullExpressionValue(string2, "Integer.toBinaryString(it)");
            objectArray2[0] = string2;
            stringArray[n5] = string = StringsKt.replace$default(Util.format("%8s", objectArray2), ' ', '0', false, 4, null);
        }
        BINARY = objectArray;
        Http2.FLAGS[0] = "";
        Http2.FLAGS[1] = "END_STREAM";
        int[] nArray = new int[]{1};
        Http2.FLAGS[8] = "PADDED";
        int[] nArray2 = nArray;
        n2 = nArray2.length;
        for (object = 0; object < n2; ++object) {
            int n6 = nArray2[object];
            Http2.FLAGS[n6 | 8] = Intrinsics.stringPlus(FLAGS[n6], "|PADDED");
        }
        Http2.FLAGS[4] = "END_HEADERS";
        Http2.FLAGS[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        Object[] objectArray3 = objectArray = (Object[])new int[]{4, 32, 36};
        int n7 = objectArray3.length;
        for (n = 0; n < n7; ++n) {
            object = objectArray3[n];
            for (int n8 : nArray) {
                Http2.FLAGS[n8 | object] = FLAGS[n8] + "|" + FLAGS[object];
                Http2.FLAGS[n8 | object | 8] = FLAGS[n8] + "|" + FLAGS[object] + "|PADDED";
            }
        }
        n = FLAGS.length;
        for (object = 0; object < n; ++object) {
            if (FLAGS[object] != null) continue;
            Http2.FLAGS[object] = BINARY[object];
        }
    }
}

