/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class JAXB {
    private static volatile WeakReference<Cache> cache;

    private JAXB() {
    }

    private static <T> JAXBContext getContext(Class<T> clazz) throws JAXBException {
        Cache cache;
        WeakReference<Cache> weakReference = JAXB.cache;
        if (weakReference != null && (cache = (Cache)weakReference.get()) != null && cache.type == clazz) {
            return cache.context;
        }
        cache = new Cache(clazz);
        JAXB.cache = new WeakReference<Cache>(cache);
        return cache.context;
    }

    public static <T> T unmarshal(File file, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(new StreamSource(file), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
    }

    public static <T> T unmarshal(URL uRL, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(uRL), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    public static <T> T unmarshal(URI uRI, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(uRI), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    public static <T> T unmarshal(String string, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(string), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    public static <T> T unmarshal(InputStream inputStream2, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(inputStream2), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    public static <T> T unmarshal(Reader reader, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(reader), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    public static <T> T unmarshal(Source source2, Class<T> clazz) {
        try {
            JAXBElement<T> jAXBElement = JAXB.getContext(clazz).createUnmarshaller().unmarshal(JAXB.toSource(source2), clazz);
            return jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    private static Source toSource(Object object) throws IOException {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("no XML is given");
        }
        if (object instanceof String) {
            try {
                object = new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                object = new File((String)object);
            }
        }
        if (object instanceof File) {
            File file = (File)object;
            return new StreamSource(file);
        }
        if (object instanceof URI) {
            object2 = (URI)object;
            object = ((URI)object2).toURL();
        }
        if (object instanceof URL) {
            object2 = (URL)object;
            return new StreamSource(((URL)object2).toExternalForm());
        }
        if (object instanceof InputStream) {
            object2 = (InputStream)object;
            return new StreamSource((InputStream)object2);
        }
        if (object instanceof Reader) {
            object2 = (Reader)object;
            return new StreamSource((Reader)object2);
        }
        if (object instanceof Source) {
            return (Source)object;
        }
        throw new IllegalArgumentException("I don't understand how to handle " + object.getClass());
    }

    public static void marshal(Object object, File file) {
        JAXB._marshal(object, file);
    }

    public static void marshal(Object object, URL uRL) {
        JAXB._marshal(object, uRL);
    }

    public static void marshal(Object object, URI uRI) {
        JAXB._marshal(object, uRI);
    }

    public static void marshal(Object object, String string) {
        JAXB._marshal(object, string);
    }

    public static void marshal(Object object, OutputStream outputStream2) {
        JAXB._marshal(object, outputStream2);
    }

    public static void marshal(Object object, Writer writer) {
        JAXB._marshal(object, writer);
    }

    public static void marshal(Object object, Result result) {
        JAXB._marshal(object, result);
    }

    private static void _marshal(Object jAXBElement, Object object) {
        try {
            Object object2;
            JAXBContext jAXBContext;
            if (jAXBElement instanceof JAXBElement) {
                jAXBContext = JAXB.getContext(((JAXBElement)jAXBElement).getDeclaredType());
            } else {
                object2 = jAXBElement.getClass();
                XmlRootElement xmlRootElement = ((Class)object2).getAnnotation(XmlRootElement.class);
                jAXBContext = JAXB.getContext(object2);
                if (xmlRootElement == null) {
                    jAXBElement = new JAXBElement<Object>(new QName(JAXB.inferName((Class)object2)), (Class<Object>)object2, jAXBElement);
                }
            }
            object2 = jAXBContext.createMarshaller();
            object2.setProperty("jaxb.formatted.output", true);
            object2.marshal((Object)jAXBElement, JAXB.toResult(object));
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException(jAXBException);
        }
        catch (IOException iOException) {
            throw new DataBindingException(iOException);
        }
    }

    private static String inferName(Class clazz) {
        return Introspector.decapitalize(clazz.getSimpleName());
    }

    private static Result toResult(Object object) throws IOException {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("no XML is given");
        }
        if (object instanceof String) {
            try {
                object = new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                object = new File((String)object);
            }
        }
        if (object instanceof File) {
            File file = (File)object;
            return new StreamResult(file);
        }
        if (object instanceof URI) {
            object2 = (URI)object;
            object = ((URI)object2).toURL();
        }
        if (object instanceof URL) {
            object2 = (URL)object;
            URLConnection uRLConnection = ((URL)object2).openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(false);
            uRLConnection.connect();
            return new StreamResult(uRLConnection.getOutputStream());
        }
        if (object instanceof OutputStream) {
            object2 = (OutputStream)object;
            return new StreamResult((OutputStream)object2);
        }
        if (object instanceof Writer) {
            object2 = (Writer)object;
            return new StreamResult((Writer)object2);
        }
        if (object instanceof Result) {
            return (Result)object;
        }
        throw new IllegalArgumentException("I don't understand how to handle " + object.getClass());
    }

    private static final class Cache {
        final Class type;
        final JAXBContext context;

        public Cache(Class clazz) throws JAXBException {
            this.type = clazz;
            this.context = JAXBContext.newInstance(clazz);
        }
    }
}

