/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@TypeQualifier(applicableTo=String.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MatchesPattern {
    @RegEx
    public String value();

    public int flags() default 0;

    public static class Checker
    implements TypeQualifierValidator<MatchesPattern> {
        @Override
        public When forConstantValue(MatchesPattern matchesPattern, Object object) {
            Pattern pattern = Pattern.compile(matchesPattern.value(), matchesPattern.flags());
            if (pattern.matcher((String)object).matches()) {
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

