/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtab;

import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class SymbolTable {
    private static final String FILE_PREFIX = "symtab";
    private static final long TMP_TABLE_MAX_COUNT = 100000L;
    private static final long FLOOR_BORDER = 256L;
    private static boolean cacheToFile = true;
    public final Vector<Symbol> symbolTable = new Vector();
    public final List<SubroutineVariable> subroutineVariables = new ArrayList<SubroutineVariable>();
    private final Vector<File> fileTable;
    private final Comparator<Symbol> comparator = (symbol, symbol2) -> (int)(symbol.getAddress() - symbol2.getAddress());
    private File symtabFile = null;
    private BufferedReader symtabFileReader = null;
    private long symbolNumber = 0L;
    private int indexOfSymbolTable = 0;
    private boolean hasDwarfInfo = false;

    public SymbolTable() {
        this.fileTable = new Vector();
    }

    public SymbolTable(boolean bl) {
        this.fileTable = new Vector();
    }

    public static void setCacheToFile(boolean bl) {
        cacheToFile = bl;
    }

    private void sortTable(Vector<Symbol> vector) {
        vector.sort(this.comparator);
    }

    public File getSymtabFile() {
        return this.symtabFile;
    }

    public long size() {
        return this.symbolNumber;
    }

    public boolean isEmpty() {
        return 0L == this.symbolNumber;
    }

    public Symbol next() {
        int n;
        if (cacheToFile) {
            if (null == this.symtabFileReader && !this.rewind()) {
                return null;
            }
            Symbol symbol = this.readFromFile(this.symtabFileReader);
            if (null == symbol) {
                FileHelper.closeFile(this.symtabFileReader);
                this.symtabFileReader = null;
            }
            return symbol;
        }
        if ((n = this.indexOfSymbolTable++) >= this.symbolTable.size()) {
            return null;
        }
        return this.symbolTable.elementAt(n);
    }

    public Symbol lastNext() {
        int n;
        if (cacheToFile) {
            if (null == this.symtabFileReader && !this.rewind()) {
                return null;
            }
            Symbol symbol = this.lastReadFromFile(this.symtabFileReader);
            if (null == symbol) {
                FileHelper.closeFile(this.symtabFileReader);
                this.symtabFileReader = null;
            }
            return symbol;
        }
        if ((n = this.indexOfSymbolTable++) >= this.symbolTable.size()) {
            return null;
        }
        Symbol symbol = this.symbolTable.elementAt(n);
        return symbol.transformSymbol();
    }

    public boolean rewind() {
        if (cacheToFile) {
            if (null == this.symtabFile) {
                if (!this.symbolTable.isEmpty() || !this.fileTable.isEmpty()) {
                    if (!this.sort()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            this.symtabFileReader = FileHelper.openFileReader(this.symtabFile);
            if (null == this.symtabFileReader) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            return true;
        }
        this.indexOfSymbolTable = 0;
        return true;
    }

    private void createSymtabFile() {
        if (null != this.symtabFile) {
            this.fileTable.add(this.symtabFile);
        }
        this.symbolNumber = 0L;
        String string = ".symtab";
        this.symtabFile = FileHelper.createTempFile(FILE_PREFIX, string);
        if (null != this.symtabFileReader) {
            FileHelper.closeFile(this.symtabFileReader);
            this.symtabFileReader = null;
        }
    }

    public boolean sort() {
        if (cacheToFile) {
            if (!this.writeToFile(this.symbolTable)) {
                return false;
            }
            this.createSymtabFile();
            return this.mergeFiles();
        }
        this.sortTable(this.symbolTable);
        return true;
    }

    private boolean fillMergeMap(TreeMap<Symbol, BufferedReader> treeMap, Vector<BufferedReader> vector) {
        block0: for (BufferedReader bufferedReader : vector) {
            Symbol symbol = this.readFromFile(bufferedReader);
            while (null != symbol) {
                if (treeMap.containsKey(symbol)) {
                    symbol = this.readFromFile(bufferedReader);
                    continue;
                }
                treeMap.put(symbol, bufferedReader);
                continue block0;
            }
        }
        return true;
    }

    private boolean mergeFiles() {
        Vector<BufferedReader> vector = FileHelper.openFiles(this.fileTable);
        if (null == vector) {
            Log.error("SymbolTable: Failed to open temp file\uff01", new Object[0]);
            return false;
        }
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(this.symtabFile);
        if (null == bufferedWriter) {
            Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
            return false;
        }
        TreeMap<Symbol, BufferedReader> treeMap = new TreeMap<Symbol, BufferedReader>(this.comparator);
        if (!this.fillMergeMap(treeMap, vector)) {
            Log.error("SymbolTable: Failed to initiate merge tree\uff01", new Object[0]);
            return false;
        }
        Symbol symbol = new Symbol();
        block0: while (!treeMap.isEmpty()) {
            Map.Entry<Symbol, BufferedReader> entry = treeMap.firstEntry();
            Symbol symbol2 = entry.getKey();
            if (symbol2.getAddress() >= 256L) {
                this.writeToFile(bufferedWriter, symbol2);
                symbol = symbol2;
                ++this.symbolNumber;
            }
            BufferedReader bufferedReader = entry.getValue();
            treeMap.remove(symbol2);
            Symbol symbol3 = this.readFromFile(bufferedReader);
            while (null != symbol3) {
                if (treeMap.containsKey(symbol3)) {
                    symbol3 = this.readFromFile(bufferedReader);
                    continue;
                }
                treeMap.put(symbol3, bufferedReader);
                continue block0;
            }
        }
        FileHelper.closeFiles(vector);
        this.deleteTmpFiles();
        if (!FileHelper.closeFile(bufferedWriter)) {
            Log.error("SymbolTable: Failed to close symtab file\uff01", new Object[0]);
        }
        return true;
    }

    private void deleteTmpFiles() {
        for (File file : this.fileTable) {
            file.delete();
        }
        this.fileTable.clear();
    }

    public void close() {
        if (null != this.symtabFileReader) {
            FileHelper.closeFile(this.symtabFileReader);
            this.symtabFileReader = null;
        }
        if (null != this.symtabFile) {
            this.symtabFile.delete();
            this.symtabFile = null;
        }
    }

    private Symbol readFromFile(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (null == string) {
                return null;
            }
            return new Symbol().parseString(string);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    private Symbol lastReadFromFile(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            if (null == string) {
                return null;
            }
            return new Symbol().parseStringLast(string);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return null;
        }
    }

    private boolean writeToFile(BufferedWriter bufferedWriter, Symbol symbol) {
        String string = symbol.toString();
        if (null == string) {
            Log.error("SymbolTable: Failed to write symbol to file\uff01", new Object[0]);
            return false;
        }
        try {
            bufferedWriter.write(symbol.toString());
            return true;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
    }

    private boolean writeToFile(Vector<Symbol> vector) {
        if (vector.isEmpty()) {
            return true;
        }
        this.sortTable(vector);
        File file = FileHelper.createTempFile(FILE_PREFIX, null);
        if (null == file) {
            return false;
        }
        this.fileTable.add(file);
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(file);
        if (null == bufferedWriter) {
            Log.error("SymbolTable: Failed to open file\uff01", new Object[0]);
            return false;
        }
        for (Symbol symbol : vector) {
            if (this.writeToFile(bufferedWriter, symbol)) continue;
            Log.error("SymbolTable: Failed to write symbol to file\uff01", new Object[0]);
            return false;
        }
        if (!FileHelper.closeFile(bufferedWriter)) {
            Log.warn("SymbolTable: Failed to close file\uff01", new Object[0]);
        }
        return true;
    }

    public boolean add(Symbol symbol) {
        if (null == symbol) {
            return false;
        }
        if (symbol.getAddress() < 256L) {
            return true;
        }
        if (cacheToFile && (long)this.symbolTable.size() >= 100000L) {
            if (!this.writeToFile(this.symbolTable)) {
                return false;
            }
            this.symbolTable.clear();
        }
        ++this.symbolNumber;
        return this.symbolTable.add(symbol);
    }

    public boolean add(Vector<Symbol> vector) {
        if (null == vector) {
            return false;
        }
        for (Symbol symbol : vector) {
            if (this.add(symbol)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(SymbolTable symbolTable) {
        if (null == symbolTable) {
            return false;
        }
        if (symbolTable.isEmpty()) {
            return true;
        }
        this.symbolTable.addAll(symbolTable.symbolTable);
        if (cacheToFile) {
            File file = symbolTable.getSymtabFile();
            if (null == file) {
                return false;
            }
            File file2 = FileHelper.createTempFile(FILE_PREFIX, null);
            if (null == file2) {
                return false;
            }
            this.fileTable.add(file2);
            BufferedReader bufferedReader = FileHelper.openFileReader(file);
            if (null == bufferedReader) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            BufferedWriter bufferedWriter = FileHelper.openFileWriter(file2);
            if (null == bufferedWriter) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            Symbol symbol = this.readFromFile(bufferedReader);
            while (null != symbol) {
                if (!this.writeToFile(bufferedWriter, symbol)) {
                    return false;
                }
                symbol = this.readFromFile(bufferedReader);
            }
            FileHelper.closeFile(bufferedReader);
            FileHelper.closeFile(bufferedWriter);
        }
        this.symbolNumber += symbolTable.size();
        return true;
    }

    public boolean isHasDwarfInfo() {
        return this.hasDwarfInfo;
    }

    public void setHasDwarfInfo(boolean bl) {
        this.hasDwarfInfo = bl;
    }
}

