/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.UnwindCode;

public class UnwindInfo {
    public byte version;
    public byte size_of_prolog;
    public byte frame_register;
    public int frame_register_offset;
    public RuntimeFunction chained_info;
    public byte[] code_bytes;

    public void parse(ParseBuffer parseBuffer, long l) {
        int n;
        parseBuffer.pos(l);
        byte by = parseBuffer.readBytes(1L)[0];
        this.version = (byte)(by & 7);
        byte by2 = (byte)(by >> 3 & 0x1F);
        if (this.version < 1 || this.version > 2) {
            return;
        }
        this.size_of_prolog = parseBuffer.readBytes(1L)[0];
        byte by3 = parseBuffer.readBytes(1L)[0];
        byte by4 = parseBuffer.readBytes(1L)[0];
        this.frame_register = (byte)(by4 & 0xF);
        this.frame_register_offset = (by4 >> 4 & 0xF) * 16;
        int n2 = (by3 & 0xFF) * 2;
        this.code_bytes = new byte[n2];
        for (n = 0; n < n2; ++n) {
            this.code_bytes[n] = parseBuffer.readBytes(1L)[0];
        }
        if (by3 % 2 != 0) {
            l += 2L;
        }
        this.chained_info = null;
        if ((by2 & 4) != 0) {
            this.chained_info = new RuntimeFunction();
            n = parseBuffer.readBytes(1L)[0];
            byte by5 = parseBuffer.readBytes(1L)[0];
            byte by6 = parseBuffer.readBytes(1L)[0];
            byte by7 = parseBuffer.readBytes(1L)[0];
            this.chained_info.beginAddr = (n & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
            n = parseBuffer.readBytes(1L)[0];
            by5 = parseBuffer.readBytes(1L)[0];
            by6 = parseBuffer.readBytes(1L)[0];
            by7 = parseBuffer.readBytes(1L)[0];
            this.chained_info.endAddr = (n & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
            n = parseBuffer.readBytes(1L)[0];
            by5 = parseBuffer.readBytes(1L)[0];
            by6 = parseBuffer.readBytes(1L)[0];
            by7 = parseBuffer.readBytes(1L)[0];
            this.chained_info.unwind_info_addr = (n & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
        }
    }

    public void parse(byte[] byArray, int n) {
        int n2;
        byte by = byArray[n++];
        this.version = (byte)(by & 7);
        byte by2 = (byte)(by >> 3 & 0x1F);
        if (this.version < 1 || this.version > 2) {
            return;
        }
        this.size_of_prolog = byArray[n++];
        byte by3 = byArray[n++];
        byte by4 = byArray[n++];
        this.frame_register = (byte)(by4 & 0xF);
        this.frame_register_offset = (by4 >> 4 & 0xF) * 16;
        int n3 = (by3 & 0xFF) * 2;
        this.code_bytes = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.code_bytes[n2] = byArray[n++];
        }
        if (by3 % 2 != 0) {
            n += 2;
        }
        this.chained_info = null;
        if ((by2 & 4) != 0) {
            this.chained_info = new RuntimeFunction();
            n2 = byArray[n++];
            byte by5 = byArray[n++];
            byte by6 = byArray[n++];
            byte by7 = byArray[n++];
            this.chained_info.beginAddr = (n2 & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
            n2 = byArray[n++];
            by5 = byArray[n++];
            by6 = byArray[n++];
            by7 = byArray[n++];
            this.chained_info.endAddr = (n2 & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
            n2 = byArray[n++];
            by5 = byArray[n++];
            by6 = byArray[n++];
            by7 = byArray[n];
            this.chained_info.unwind_info_addr = (n2 & 0xFF) + (by5 & 0xFF) * 256 + (by6 & 0xFF) * 256 * 256 + (by7 & 0xFF) * 256 * 256 * 256;
        }
    }

    public String getFrameRegisterName() {
        return UnwindCode.getName(this.frame_register);
    }
}

