/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pe.StackFrameOffset;
import com.uqm.crashsight.symtabtool.pe.UnwindOperation;

public class UnwindCode {
    public byte code_offset;
    public UnwindOperation operation;
    public int offset;
    public byte Register;
    public StackFrameOffset sfo;
    public boolean is_error;

    public int parse(byte[] byArray, int n, byte by) {
        this.code_offset = byArray[n++];
        byte by2 = (byte)(byArray[n] & 0xF);
        byte by3 = (byte)(byArray[n++] >> 4 & 0xF);
        switch (by2) {
            case 0: {
                this.Register = by3;
                this.operation = UnwindOperation.PushNonVolatile;
                break;
            }
            case 1: {
                this.operation = UnwindOperation.Alloc;
                if (by3 == 0) {
                    n = this.WORD_read(byArray, n);
                    break;
                }
                if (by3 != 1) break;
                n = this.DW_read(byArray, n);
                break;
            }
            case 2: {
                this.operation = UnwindOperation.Alloc;
                this.offset = by3 * 8 + 8;
                break;
            }
            case 3: {
                this.operation = UnwindOperation.SetFPRegister;
                break;
            }
            case 4: {
                this.operation = UnwindOperation.SaveNonVolatile;
                this.Register = by3;
                n = this.WORD_read(byArray, n);
                if (by == 0) {
                    this.sfo = StackFrameOffset.RSP;
                    break;
                }
                this.sfo = StackFrameOffset.FP;
                break;
            }
            case 5: {
                this.operation = UnwindOperation.SaveNonVolatile;
                this.Register = by3;
                n = this.DW_read(byArray, n);
                if (by == 0) {
                    this.sfo = StackFrameOffset.RSP;
                    break;
                }
                this.sfo = StackFrameOffset.FP;
                break;
            }
            case 6: {
                this.operation = UnwindOperation.Noop;
                n += 2;
                break;
            }
            case 7: {
                this.operation = UnwindOperation.Noop;
                n += 4;
                break;
            }
            case 8: {
                this.operation = UnwindOperation.Noop;
                n += 2;
                break;
            }
            case 9: {
                this.operation = UnwindOperation.Noop;
                n += 4;
                break;
            }
            case 10: {
                this.operation = UnwindOperation.PushMachineFrame;
                if (by3 == 0) {
                    this.is_error = false;
                    break;
                }
                if (by3 != 1) break;
                this.is_error = true;
                break;
            }
            default: {
                this.operation = UnwindOperation.Noop;
            }
        }
        return n;
    }

    private int WORD_read(byte[] byArray, int n) {
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        this.offset = ((by & 0xFF) + (by2 & 0xFF) * 256) * 8;
        return n;
    }

    private int DW_read(byte[] byArray, int n) {
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        byte by3 = byArray[n++];
        byte by4 = byArray[n++];
        this.offset = (by & 0xFF) + (by2 & 0xFF) * 256 + (by3 & 0xFF) * 256 * 256 + (by4 & 0xFF) * 256 * 256 * 256;
        return n;
    }

    public String getRegisterName() {
        return UnwindCode.getName(this.Register);
    }

    static String getName(byte by) {
        switch (by) {
            case 0: {
                return "$rax";
            }
            case 1: {
                return "$rcx";
            }
            case 2: {
                return "$rdx";
            }
            case 3: {
                return "$rbx";
            }
            case 4: {
                return "$rsp";
            }
            case 5: {
                return "$rbp";
            }
            case 6: {
                return "$rsi";
            }
            case 7: {
                return "$rdi";
            }
            case 8: {
                return "$r8";
            }
            case 9: {
                return "$r9";
            }
            case 10: {
                return "$r10";
            }
            case 11: {
                return "$r11";
            }
            case 12: {
                return "$r12";
            }
            case 13: {
                return "$r13";
            }
            case 14: {
                return "$r14";
            }
            case 15: {
                return "$r15";
            }
            case 16: {
                return "$rip";
            }
            case 17: {
                return "$xmm0";
            }
            case 18: {
                return "$xmm1";
            }
            case 19: {
                return "$xmm2";
            }
            case 20: {
                return "$xmm3";
            }
            case 21: {
                return "$xmm4";
            }
            case 22: {
                return "$xmm5";
            }
            case 23: {
                return "$xmm6";
            }
            case 24: {
                return "$xmm7";
            }
            case 25: {
                return "$xmm8";
            }
            case 26: {
                return "$xmm9";
            }
            case 27: {
                return "$xmm10";
            }
            case 28: {
                return "$xmm11";
            }
            case 29: {
                return "$xmm12";
            }
            case 30: {
                return "$xmm13";
            }
            case 31: {
                return "$xmm14";
            }
            case 32: {
                return "$xmm15";
            }
        }
        return "";
    }
}

