/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.common.CodeId;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.goblin.Goblin;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.PE;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.UnwindCode;
import com.uqm.crashsight.symtabtool.pe.UnwindInfo;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;
import com.uqm.crashsight.symtabtool.pe.header.Header;
import com.uqm.crashsight.symtabtool.pe.header.OptionalHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Stack;

public class PeObject {
    public PE pe;
    ParseBuffer buffer;
    boolean isStub;
    public String peFileName = "";
    Cpu cpu;
    String debugId = "";
    String codeId;
    String stack;
    public String symbolPath = "";
    String peName = "";
    public boolean useTempDir = false;
    public String appName = "";

    public PeObject(String string, String string2) {
        Object object;
        this.peName = Paths.get(string, new String[0]).getFileName().toString();
        File file = null;
        long l = 0L;
        if (string2.equals("PDB") ? (l = (file = new File((String)(object = string.substring(0, string.length() - 4) + ".exe"))).length()) == 0L && (l = (file = new File((String)(object = string.substring(0, string.length() - 4) + ".dll"))).length()) == 0L : (l = (file = new File(string)).length()) == 0L) {
            return;
        }
        object = new byte[(int)l];
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            for (int i = 0; i < ((Object)object).length && (n = fileInputStream.read((byte[])object, i, ((Object)object).length - i)) >= 0; i += n) {
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.buffer = new ParseBuffer((byte[])object);
        this.pe = PE.parse(this.buffer);
        this.appName = this.peName.substring(0, this.peName.lastIndexOf(46));
        this.peFileName = string;
        this.debugId = this.pe.getDebugId();
    }

    public static boolean isPeStub(PE pE) {
        return true;
    }

    public boolean test(ParseBuffer parseBuffer) {
        return Goblin.peek(parseBuffer).getPe();
    }

    public static PeObject parse(ParseBuffer parseBuffer) {
        PeObject peObject = new PeObject("", "");
        return peObject;
    }

    public String processCfi() {
        RuntimeFunction[] runtimeFunctionArray;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        Stack<UnwindCode> stack = new Stack<UnwindCode>();
        DataDirectories.DataDirectory dataDirectory = this.pe.getHeader().getOptionalHeader().getDataDirectories().getExceptionTable();
        Section[] sectionArray = this.pe.sections;
        if (this.pe.exceptionData == null) {
            Log.error("Exception data is missing.", new Object[0]);
            return null;
        }
        for (RuntimeFunction runtimeFunction : runtimeFunctionArray = this.pe.exceptionData.findFunctions(this.buffer)) {
            if (runtimeFunction.beginAddr == 0L && runtimeFunction.endAddr == 0L && runtimeFunction.unwind_info_addr == 0L || runtimeFunction.beginAddr > runtimeFunction.endAddr) continue;
            int n = 8;
            int n2 = 0;
            stringBuilder2.delete(0, stringBuilder2.length());
            stringBuilder3.delete(0, stringBuilder3.length());
            RuntimeFunction runtimeFunction2 = runtimeFunction;
            int n3 = 0;
            while (runtimeFunction2 != null) {
                int n4;
                ++n3;
                UnwindInfo unwindInfo = new UnwindInfo();
                for (n4 = 0; n4 < sectionArray.length; ++n4) {
                    if (!sectionArray[n4].is_in_section(runtimeFunction2.unwind_info_addr, this.pe.fileAlignment)) continue;
                    long l = runtimeFunction2.unwind_info_addr - sectionArray[n4].virtualAddress + (sectionArray[n4].pointerToRawData & 0xFFFFFFFFFFFFFE00L);
                    unwindInfo.parse(this.buffer, l);
                    break;
                }
                if (unwindInfo == null || unwindInfo.code_bytes == null) {
                    runtimeFunction2 = null;
                    continue;
                }
                n4 = 0;
                while (n4 < unwindInfo.code_bytes.length) {
                    UnwindCode unwindCode = new UnwindCode();
                    n4 = unwindCode.parse(unwindInfo.code_bytes, n4, unwindInfo.frame_register);
                    stack.push(unwindCode);
                }
                while (!stack.empty()) {
                    UnwindCode unwindCode = (UnwindCode)stack.peek();
                    switch (unwindCode.operation) {
                        case SaveNonVolatile: {
                            break;
                        }
                        case PushNonVolatile: {
                            n += 8;
                            break;
                        }
                        case Alloc: {
                            n += unwindCode.offset;
                            break;
                        }
                        case SetFPRegister: {
                            int n5 = n - unwindInfo.frame_register_offset;
                            break;
                        }
                        case PushMachineFrame: {
                            int n5 = n + 16;
                            int n6 = n + 40;
                            stringBuilder3.append(" $rsp: .cfa ").append(n5).append(" - ^ .ra: .cfa ").append(n6).append(" - ^");
                            n2 = n += 40;
                            if (!unwindCode.is_error) break;
                            n += 8;
                            break;
                        }
                    }
                    stack.pop();
                }
                runtimeFunction2 = unwindInfo.chained_info;
            }
            if (stringBuilder2.length() == 0) {
                stringBuilder2.append(".cfa: $rsp ").append(n).append(" +");
            }
            if (n2 == 0) {
                stringBuilder3.append(".cfa: $rsp .ra: .cfa 8 - ^");
            }
            stringBuilder.append("STACK CFI INIT ").append(Long.toHexString(runtimeFunction.beginAddr)).append(" ").append(Long.toHexString(runtimeFunction.endAddr - runtimeFunction.beginAddr)).append(" ");
            stringBuilder.append((CharSequence)stringBuilder3);
            stringBuilder.append("\n");
            stringBuilder.append("STACK CFI ").append(Long.toHexString(runtimeFunction.beginAddr)).append(" ").append((CharSequence)stringBuilder2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getDebugId() {
        return this.debugId;
    }

    public CodeId getCodeId() {
        Header header = this.pe.getHeader();
        OptionalHeader optionalHeader = header.getOptionalHeader();
        long l = header.getCoffHeader().getTimeDateStamp();
        long l2 = optionalHeader.getWindowsFields().getSizeOfImage();
        String string = String.format("%x%x", l, l2);
        return new CodeId(string);
    }

    public String getArch() {
        return this.cpu.toString();
    }

    public boolean load() {
        try {
            Log.info("Begin to parse file: %s", this.peFileName);
            this.cpu = this.pe.getCpu();
            if (this.cpu.name().equals("X86")) {
                Log.error("X86 is not supported.", new Object[0]);
                return false;
            }
            this.codeId = this.getCodeId().getInner();
            this.debugId = this.pe.getDebugId();
            if (this.debugId == "") {
                return false;
            }
            this.stack = this.processCfi();
            if (this.stack == null) {
                return false;
            }
            this.symbolPath = this.peSymtabFileNameFormatter();
            BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symbolPath));
            this.display(bufferedWriter);
            assert (bufferedWriter != null);
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(String.format("MODULE windows %s %s %s\n", new Object[]{this.cpu, this.debugId, this.peName}));
            if (this.codeId != null && !this.codeId.isEmpty()) {
                bufferedWriter.write(String.format("INFO CODE_ID %s %s\n", this.codeId, this.peName));
            }
            bufferedWriter.write(String.format("%s\n", this.stack));
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    private String peSymtabFileNameFormatter() {
        String string = Paths.get(this.peFileName, new String[0]).getParent().toString();
        if (this.useTempDir) {
            string = System.getProperty("java.io.tmpdir");
        }
        this.appName = this.peName.substring(0, this.peName.lastIndexOf(46));
        String string2 = "crashsightSymbol";
        string2 = string2 + "&";
        string2 = string2 + this.getArch();
        string2 = string2 + "&";
        string2 = string2 + Utils.urlEncodeString(this.appName);
        string2 = string2 + "&";
        string2 = string2 + this.debugId;
        string2 = string2 + ".sym";
        return Paths.get(string, string2).toString();
    }
}

