/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.types;

import com.uqm.crashsight.symtabtool.common.utils.StrUtils;
import com.uqm.crashsight.symtabtool.pdb.types.DemangleOptions;
import com.uqm.crashsight.symtabtool.pdb.types.Language;
import com.uqm.crashsight.symtabtool.pdb.types.NameMangling;

public class Name {
    String string;
    Language lang;
    NameMangling mangling;

    public Name(String string, NameMangling nameMangling, Language language) {
        this.string = string;
        this.mangling = nameMangling;
        this.lang = language;
    }

    public Language detectLanguage() {
        if (this.lang != Language.Unknown) {
            return this.lang;
        }
        if (Name.isMaybeObjc(this.string)) {
            return Language.ObjC;
        }
        if (Name.isMaybeCpp(this.string) || Name.isMaybeMsvc(this.string)) {
            return Language.Cpp;
        }
        return Language.Unknown;
    }

    public static boolean isMaybeObjc(String string) {
        return (string.startsWith("-[") || string.startsWith("+[")) && string.endsWith("]");
    }

    public static boolean isMaybeCpp(String string) {
        return string.startsWith("_Z") || string.startsWith("__Z") || string.endsWith("___Z") || string.startsWith("____Z");
    }

    public static boolean isMaybeMsvc(String string) {
        return string.startsWith("?") || string.startsWith("@?");
    }

    public static boolean isMaybeMd5(String string) {
        if (string.length() != 36) {
            return false;
        }
        return string.startsWith("??@") && string.endsWith("@") && StrUtils.isAsciiHexDigit(string.substring(3, 35));
    }

    public String demangle(DemangleOptions demangleOptions) {
        if (this.mangling == NameMangling.Unmangled || Name.isMaybeMd5(this.string)) {
            return this.string;
        }
        switch (this.detectLanguage()) {
            case ObjC: {
                return Name.demangleObjc(this.string, demangleOptions);
            }
            case ObjCpp: {
                return Name.tryDemangleObjCpp(this.string, demangleOptions);
            }
            case Rust: {
                return Name.tryDemangleRust(this.string, demangleOptions);
            }
            case Cpp: {
                return Name.tryDemangleCpp(this.string, demangleOptions);
            }
            case Swift: {
                return Name.tryDemangleSwift(this.string, demangleOptions);
            }
        }
        return null;
    }

    public static String demangleObjc(String string, DemangleOptions demangleOptions) {
        return string;
    }

    public static String tryDemangleObjCpp(String string, DemangleOptions demangleOptions) {
        return string;
    }

    public static String tryDemangleRust(String string, DemangleOptions demangleOptions) {
        return string;
    }

    public static String tryDemangleCpp(String string, DemangleOptions demangleOptions) {
        return string;
    }

    public static String tryDemangleSwift(String string, DemangleOptions demangleOptions) {
        return string;
    }

    public static String demangleObjCpp(String string, DemangleOptions demangleOptions) {
        if (Name.isMaybeObjc(string)) {
            return Name.demangleObjc(string, demangleOptions);
        }
        if (Name.isMaybeCpp(string)) {
            return Name.tryDemangleCpp(string, demangleOptions);
        }
        return null;
    }

    public static String normalizeAnonymousNamespace(String string) {
        return string.replace("`anonymous namespace'", "(anonymous namespace)");
    }

    public static Name fixSymbolName(Name name) {
        String string = name.getString().replaceAll("\\.llm\\.[0-9]+$]", "");
        string = Name.normalizeAnonymousNamespace(string);
        return new Name(string, name.mangling, name.lang);
    }

    public String getString() {
        return this.string;
    }

    public Language getLang() {
        return this.lang;
    }

    public NameMangling getMangling() {
        return this.mangling;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setLang(Language language) {
        this.lang = language;
    }

    public void setMangling(NameMangling nameMangling) {
        this.mangling = nameMangling;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (!name.canEqual(this)) {
            return false;
        }
        String string = this.getString();
        String string2 = name.getString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Language language = this.getLang();
        Language language2 = name.getLang();
        if (language == null ? language2 != null : !((Object)((Object)language)).equals((Object)language2)) {
            return false;
        }
        NameMangling nameMangling = this.getMangling();
        NameMangling nameMangling2 = name.getMangling();
        return !(nameMangling == null ? nameMangling2 != null : !((Object)((Object)nameMangling)).equals((Object)nameMangling2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Name;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getString();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Language language = this.getLang();
        n2 = n2 * 59 + (language == null ? 43 : ((Object)((Object)language)).hashCode());
        NameMangling nameMangling = this.getMangling();
        n2 = n2 * 59 + (nameMangling == null ? 43 : ((Object)((Object)nameMangling)).hashCode());
        return n2;
    }

    public String toString() {
        return "Name(string=" + this.getString() + ", lang=" + (Object)((Object)this.getLang()) + ", mangling=" + (Object)((Object)this.getMangling()) + ")";
    }
}

