/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.tpi.Indirection;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeData;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;

public class Primitive {
    public static TypeData typeDataForPrimitive(TypeIndex typeIndex) {
        long l = typeIndex.index;
        assert (l < 4096L);
        int n = (int)(l & 0xF00L);
        Indirection indirection = null;
        switch (n) {
            case 0: {
                indirection = null;
                break;
            }
            case 256: {
                indirection = Indirection.Near16;
                break;
            }
            case 512: {
                indirection = Indirection.Far16;
                break;
            }
            case 768: {
                indirection = Indirection.Huge16;
                break;
            }
            case 1024: {
                indirection = Indirection.Near32;
                break;
            }
            case 1280: {
                indirection = Indirection.Far32;
                break;
            }
            case 1536: {
                indirection = Indirection.Near64;
                break;
            }
            case 1792: {
                indirection = Indirection.Near128;
                break;
            }
            default: {
                Log.error("TypeNotFound(%d)", l);
            }
        }
        n = (int)l & 0xFF;
        PrimitiveKind primitiveKind = null;
        switch (n) {
            case 0: {
                primitiveKind = PrimitiveKind.NoType;
                break;
            }
            case 3: {
                primitiveKind = PrimitiveKind.Void;
                break;
            }
            case 8: {
                primitiveKind = PrimitiveKind.HRESULT;
                break;
            }
            case 16: {
                primitiveKind = PrimitiveKind.Char;
                break;
            }
            case 32: {
                primitiveKind = PrimitiveKind.UChar;
                break;
            }
            case 104: {
                primitiveKind = PrimitiveKind.I8;
                break;
            }
            case 105: {
                primitiveKind = PrimitiveKind.U8;
                break;
            }
            case 112: {
                primitiveKind = PrimitiveKind.RChar;
                break;
            }
            case 113: {
                primitiveKind = PrimitiveKind.WChar;
                break;
            }
            case 122: {
                primitiveKind = PrimitiveKind.RChar16;
                break;
            }
            case 123: {
                primitiveKind = PrimitiveKind.RChar32;
                break;
            }
            case 17: {
                primitiveKind = PrimitiveKind.Short;
                break;
            }
            case 33: {
                primitiveKind = PrimitiveKind.UShort;
                break;
            }
            case 114: {
                primitiveKind = PrimitiveKind.I16;
                break;
            }
            case 115: {
                primitiveKind = PrimitiveKind.U16;
                break;
            }
            case 18: {
                primitiveKind = PrimitiveKind.Long;
                break;
            }
            case 34: {
                primitiveKind = PrimitiveKind.ULong;
                break;
            }
            case 116: {
                primitiveKind = PrimitiveKind.I32;
                break;
            }
            case 117: {
                primitiveKind = PrimitiveKind.U32;
                break;
            }
            case 19: {
                primitiveKind = PrimitiveKind.Quad;
                break;
            }
            case 35: {
                primitiveKind = PrimitiveKind.UQuad;
                break;
            }
            case 118: {
                primitiveKind = PrimitiveKind.I64;
                break;
            }
            case 119: {
                primitiveKind = PrimitiveKind.U64;
                break;
            }
            case 20: {
                primitiveKind = PrimitiveKind.Octa;
                break;
            }
            case 36: {
                primitiveKind = PrimitiveKind.UOcta;
                break;
            }
            case 120: {
                primitiveKind = PrimitiveKind.I128;
                break;
            }
            case 121: {
                primitiveKind = PrimitiveKind.U128;
                break;
            }
            case 70: {
                primitiveKind = PrimitiveKind.F16;
                break;
            }
            case 64: {
                primitiveKind = PrimitiveKind.F32;
                break;
            }
            case 69: {
                primitiveKind = PrimitiveKind.F32PP;
                break;
            }
            case 68: {
                primitiveKind = PrimitiveKind.F48;
                break;
            }
            case 65: {
                primitiveKind = PrimitiveKind.F64;
                break;
            }
            case 66: {
                primitiveKind = PrimitiveKind.F80;
                break;
            }
            case 67: {
                primitiveKind = PrimitiveKind.F128;
                break;
            }
            case 80: {
                primitiveKind = PrimitiveKind.Complex32;
                break;
            }
            case 81: {
                primitiveKind = PrimitiveKind.Complex64;
                break;
            }
            case 82: {
                primitiveKind = PrimitiveKind.Complex80;
                break;
            }
            case 83: {
                primitiveKind = PrimitiveKind.Complex128;
                break;
            }
            case 48: {
                primitiveKind = PrimitiveKind.Bool8;
                break;
            }
            case 49: {
                primitiveKind = PrimitiveKind.Bool16;
                break;
            }
            case 50: {
                primitiveKind = PrimitiveKind.Bool32;
                break;
            }
            case 51: {
                primitiveKind = PrimitiveKind.Bool64;
                break;
            }
            default: {
                Log.error("TypeNotFound(%d)", l);
            }
        }
        PrimitiveType primitiveType = new PrimitiveType(primitiveKind, indirection);
        TypeData typeData = new TypeData(TypeEnum.class);
        typeData.put(TypeEnum.Primitive, primitiveType);
        return typeData;
    }
}

