/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerMode;

public class PointerAttributes {
    long value;

    public PointerAttributes(long l) {
        this.value = l;
    }

    public static PointerAttributes parse(ParseBuffer parseBuffer) {
        return new PointerAttributes(parseBuffer.readU32());
    }

    public PointerMode pointerMode() {
        long l = this.value >> 5 & 7L;
        switch ((int)l) {
            case 0: {
                return PointerMode.Pointer;
            }
            case 1: {
                return PointerMode.LValueReference;
            }
            case 2: {
                return PointerMode.Member;
            }
            case 3: {
                return PointerMode.MemberFunction;
            }
            case 4: {
                return PointerMode.RValueReference;
            }
        }
        return null;
    }

    boolean pointerToMember() {
        PointerMode pointerMode = this.pointerMode();
        return pointerMode == PointerMode.Member || pointerMode == PointerMode.MemberFunction;
    }

    public PointerKind pointerKind() {
        int n = (int)this.value & 0x1F;
        switch (n) {
            case 0: {
                return PointerKind.Near16;
            }
            case 1: {
                return PointerKind.Far16;
            }
            case 2: {
                return PointerKind.Huge16;
            }
            case 3: {
                return PointerKind.BaseSeg;
            }
            case 4: {
                return PointerKind.BaseVal;
            }
            case 5: {
                return PointerKind.BaseSegVal;
            }
            case 6: {
                return PointerKind.BaseAddr;
            }
            case 7: {
                return PointerKind.BaseSegAddr;
            }
            case 8: {
                return PointerKind.BaseType;
            }
            case 9: {
                return PointerKind.BaseSelf;
            }
            case 10: {
                return PointerKind.Near32;
            }
            case 11: {
                return PointerKind.Far32;
            }
            case 12: {
                return PointerKind.Ptr64;
            }
        }
        Log.error("unreachable", new Object[0]);
        return null;
    }

    public int size() {
        long l = this.value >> 13 & 0x3FL;
        if (l != 0L) {
            return (int)l;
        }
        PointerKind pointerKind = this.pointerKind();
        switch (pointerKind) {
            case Near32: 
            case Far32: {
                return 4;
            }
            case Ptr64: {
                return 8;
            }
        }
        return 0;
    }

    public boolean isConst() {
        return (this.value & 0x400L) != 0L;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PointerAttributes)) {
            return false;
        }
        PointerAttributes pointerAttributes = (PointerAttributes)object;
        if (!pointerAttributes.canEqual(this)) {
            return false;
        }
        return this.getValue() == pointerAttributes.getValue();
    }

    protected boolean canEqual(Object object) {
        return object instanceof PointerAttributes;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getValue();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        return n2;
    }

    public String toString() {
        return "PointerAttributes(value=" + this.getValue() + ")";
    }
}

