/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SeparatedCodeFlags;

public class SeparatedCodeSymbol {
    long parent;
    long end;
    long len;
    SeparatedCodeFlags flags;
    PdbInternalSectionOffset offset;
    PdbInternalSectionOffset parentOffset;

    public SeparatedCodeSymbol(long l, long l2, long l3, SeparatedCodeFlags separatedCodeFlags, PdbInternalSectionOffset pdbInternalSectionOffset, PdbInternalSectionOffset pdbInternalSectionOffset2) {
        this.parent = l;
        this.end = l2;
        this.len = l3;
        this.flags = separatedCodeFlags;
        this.offset = pdbInternalSectionOffset;
        this.parentOffset = pdbInternalSectionOffset2;
    }

    public static SeparatedCodeSymbol parse(ParseBuffer parseBuffer) {
        try {
            long l = parseBuffer.readU32();
            long l2 = parseBuffer.readU32();
            long l3 = parseBuffer.readU32();
            SeparatedCodeFlags separatedCodeFlags = SeparatedCodeFlags.parse(parseBuffer);
            long l4 = parseBuffer.readU32();
            long l5 = parseBuffer.readU32();
            int n = parseBuffer.readU16();
            int n2 = parseBuffer.readU16();
            return new SeparatedCodeSymbol(l, l2, l3, separatedCodeFlags, new PdbInternalSectionOffset(l4, n), new PdbInternalSectionOffset(l5, n2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLen() {
        return this.len;
    }

    public SeparatedCodeFlags getFlags() {
        return this.flags;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public PdbInternalSectionOffset getParentOffset() {
        return this.parentOffset;
    }

    public void setParent(long l) {
        this.parent = l;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setLen(long l) {
        this.len = l;
    }

    public void setFlags(SeparatedCodeFlags separatedCodeFlags) {
        this.flags = separatedCodeFlags;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setParentOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.parentOffset = pdbInternalSectionOffset;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SeparatedCodeSymbol)) {
            return false;
        }
        SeparatedCodeSymbol separatedCodeSymbol = (SeparatedCodeSymbol)object;
        if (!separatedCodeSymbol.canEqual(this)) {
            return false;
        }
        if (this.getParent() != separatedCodeSymbol.getParent()) {
            return false;
        }
        if (this.getEnd() != separatedCodeSymbol.getEnd()) {
            return false;
        }
        if (this.getLen() != separatedCodeSymbol.getLen()) {
            return false;
        }
        SeparatedCodeFlags separatedCodeFlags = this.getFlags();
        SeparatedCodeFlags separatedCodeFlags2 = separatedCodeSymbol.getFlags();
        if (separatedCodeFlags == null ? separatedCodeFlags2 != null : !((Object)separatedCodeFlags).equals(separatedCodeFlags2)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = separatedCodeSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset3 = this.getParentOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset4 = separatedCodeSymbol.getParentOffset();
        return !(pdbInternalSectionOffset3 == null ? pdbInternalSectionOffset4 != null : !((Object)pdbInternalSectionOffset3).equals(pdbInternalSectionOffset4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SeparatedCodeSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getParent();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getEnd();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getLen();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        SeparatedCodeFlags separatedCodeFlags = this.getFlags();
        n2 = n2 * 59 + (separatedCodeFlags == null ? 43 : ((Object)separatedCodeFlags).hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset2 = this.getParentOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset2 == null ? 43 : ((Object)pdbInternalSectionOffset2).hashCode());
        return n2;
    }

    public String toString() {
        return "SeparatedCodeSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", len=" + this.getLen() + ", flags=" + this.getFlags() + ", offset=" + this.getOffset() + ", parentOffset=" + this.getParentOffset() + ")";
    }
}

