/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ProcedureSymbol {
    private boolean global;
    private boolean dpc;
    private Long parent;
    private long end;
    private Long next;
    private long len;
    private long dbgStartOffset;
    private long dbgEndOffset;
    private long typeIndex;
    private PdbInternalSectionOffset offset;
    private ProcedureFlags flags;
    String name;

    public static ProcedureSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            ProcedureSymbol procedureSymbol = new ProcedureSymbol();
            procedureSymbol.setGlobal(n == 4368 || n == 4107 || n == 4423);
            procedureSymbol.setDpc(n == 4437 || n == 4438);
            long l = parseBuffer.readU32();
            procedureSymbol.setParent(l == 0L ? null : Long.valueOf(l));
            procedureSymbol.setEnd(parseBuffer.readU32());
            long l2 = parseBuffer.readU32();
            procedureSymbol.setNext(l2 == 0L ? null : Long.valueOf(l2));
            procedureSymbol.setLen(parseBuffer.readU32());
            procedureSymbol.setDbgStartOffset(parseBuffer.readU32());
            procedureSymbol.setDbgEndOffset(parseBuffer.readU32());
            procedureSymbol.setTypeIndex(parseBuffer.readU32());
            PdbInternalSectionOffset pdbInternalSectionOffset = PdbInternalSectionOffset.parse(parseBuffer);
            procedureSymbol.setOffset(pdbInternalSectionOffset);
            procedureSymbol.setFlags(ProcedureFlags.parse(parseBuffer));
            procedureSymbol.setName(Utils.parseSymbolName(parseBuffer, n));
            return procedureSymbol;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isDpc() {
        return this.dpc;
    }

    public Long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public Long getNext() {
        return this.next;
    }

    public long getLen() {
        return this.len;
    }

    public long getDbgStartOffset() {
        return this.dbgStartOffset;
    }

    public long getDbgEndOffset() {
        return this.dbgEndOffset;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public ProcedureFlags getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public void setDpc(boolean bl) {
        this.dpc = bl;
    }

    public void setParent(Long l) {
        this.parent = l;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setNext(Long l) {
        this.next = l;
    }

    public void setLen(long l) {
        this.len = l;
    }

    public void setDbgStartOffset(long l) {
        this.dbgStartOffset = l;
    }

    public void setDbgEndOffset(long l) {
        this.dbgEndOffset = l;
    }

    public void setTypeIndex(long l) {
        this.typeIndex = l;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setFlags(ProcedureFlags procedureFlags) {
        this.flags = procedureFlags;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProcedureSymbol)) {
            return false;
        }
        ProcedureSymbol procedureSymbol = (ProcedureSymbol)object;
        if (!procedureSymbol.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != procedureSymbol.isGlobal()) {
            return false;
        }
        if (this.isDpc() != procedureSymbol.isDpc()) {
            return false;
        }
        if (this.getEnd() != procedureSymbol.getEnd()) {
            return false;
        }
        if (this.getLen() != procedureSymbol.getLen()) {
            return false;
        }
        if (this.getDbgStartOffset() != procedureSymbol.getDbgStartOffset()) {
            return false;
        }
        if (this.getDbgEndOffset() != procedureSymbol.getDbgEndOffset()) {
            return false;
        }
        if (this.getTypeIndex() != procedureSymbol.getTypeIndex()) {
            return false;
        }
        Long l = this.getParent();
        Long l2 = procedureSymbol.getParent();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            return false;
        }
        Long l3 = this.getNext();
        Long l4 = procedureSymbol.getNext();
        if (l3 == null ? l4 != null : !((Object)l3).equals(l4)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = procedureSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        ProcedureFlags procedureFlags = this.getFlags();
        ProcedureFlags procedureFlags2 = procedureSymbol.getFlags();
        if (procedureFlags == null ? procedureFlags2 != null : !((Object)procedureFlags).equals(procedureFlags2)) {
            return false;
        }
        String string = this.getName();
        String string2 = procedureSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ProcedureSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isGlobal() ? 79 : 97);
        n2 = n2 * 59 + (this.isDpc() ? 79 : 97);
        long l = this.getEnd();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getLen();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getDbgStartOffset();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getDbgEndOffset();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getTypeIndex();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        Long l6 = this.getParent();
        n2 = n2 * 59 + (l6 == null ? 43 : ((Object)l6).hashCode());
        Long l7 = this.getNext();
        n2 = n2 * 59 + (l7 == null ? 43 : ((Object)l7).hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        ProcedureFlags procedureFlags = this.getFlags();
        n2 = n2 * 59 + (procedureFlags == null ? 43 : ((Object)procedureFlags).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "ProcedureSymbol(global=" + this.isGlobal() + ", dpc=" + this.isDpc() + ", parent=" + this.getParent() + ", end=" + this.getEnd() + ", next=" + this.getNext() + ", len=" + this.getLen() + ", dbgStartOffset=" + this.getDbgStartOffset() + ", dbgEndOffset=" + this.getDbgEndOffset() + ", typeIndex=" + this.getTypeIndex() + ", offset=" + this.getOffset() + ", flags=" + this.getFlags() + ", name=" + this.getName() + ")";
    }
}

