/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import java.io.BufferedWriter;

public class PDBSymbol {
    String name;
    boolean isPublic;
    boolean isMultiple;
    long rva;
    long len;
    long parameterSize;
    Lines source;
    long id;

    public PDBSymbol(String string, boolean bl, boolean bl2, long l, long l2, long l3, Lines lines, long l4) {
        this.name = string;
        this.isPublic = bl;
        this.isMultiple = bl2;
        this.rva = l;
        this.len = l2;
        this.parameterSize = l3;
        this.source = lines;
        this.id = l4;
    }

    public PDBSymbol getFrom(long l, long l2) {
        Lines lines = this.source.retain(l, l2);
        if (lines == null) {
            lines = this.source;
        }
        return new PDBSymbol(this.name, this.isPublic, this.isMultiple, l, l2, this.parameterSize, lines, this.id);
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            if (this.isPublic) {
                bufferedWriter.write(String.format("PUBLIC %s%x %x %s\n", this.isMultiple ? "m " : "", this.rva, this.parameterSize, this.name));
            } else {
                bufferedWriter.write(String.format("FUNC %s%x %x %x %s\n", this.isMultiple ? "m " : "", this.rva, this.len, this.parameterSize, this.name));
                if (this.source == null) {
                    return;
                }
                this.source.display(bufferedWriter);
            }
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public long getRva() {
        return this.rva;
    }

    public long getLen() {
        return this.len;
    }

    public long getParameterSize() {
        return this.parameterSize;
    }

    public Lines getSource() {
        return this.source;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    public void setMultiple(boolean bl) {
        this.isMultiple = bl;
    }

    public void setRva(long l) {
        this.rva = l;
    }

    public void setLen(long l) {
        this.len = l;
    }

    public void setParameterSize(long l) {
        this.parameterSize = l;
    }

    public void setSource(Lines lines) {
        this.source = lines;
    }

    public void setId(long l) {
        this.id = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDBSymbol)) {
            return false;
        }
        PDBSymbol pDBSymbol = (PDBSymbol)object;
        if (!pDBSymbol.canEqual(this)) {
            return false;
        }
        if (this.isPublic() != pDBSymbol.isPublic()) {
            return false;
        }
        if (this.isMultiple() != pDBSymbol.isMultiple()) {
            return false;
        }
        if (this.getRva() != pDBSymbol.getRva()) {
            return false;
        }
        if (this.getLen() != pDBSymbol.getLen()) {
            return false;
        }
        if (this.getParameterSize() != pDBSymbol.getParameterSize()) {
            return false;
        }
        if (this.getId() != pDBSymbol.getId()) {
            return false;
        }
        String string = this.getName();
        String string2 = pDBSymbol.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Lines lines = this.getSource();
        Lines lines2 = pDBSymbol.getSource();
        return !(lines == null ? lines2 != null : !((Object)lines).equals(lines2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDBSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isPublic() ? 79 : 97);
        n2 = n2 * 59 + (this.isMultiple() ? 79 : 97);
        long l = this.getRva();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getLen();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getParameterSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getId();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Lines lines = this.getSource();
        n2 = n2 * 59 + (lines == null ? 43 : ((Object)lines).hashCode());
        return n2;
    }

    public String toString() {
        return "PDBSymbol(name=" + this.getName() + ", isPublic=" + this.isPublic() + ", isMultiple=" + this.isMultiple() + ", rva=" + this.getRva() + ", len=" + this.getLen() + ", parameterSize=" + this.getParameterSize() + ", source=" + this.getSource() + ", id=" + this.getId() + ")";
    }
}

