/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;

public class PdbInternalRva {
    Long address;

    public PdbInternalRva(Long l) {
        this.address = l;
    }

    public Rva toRva(AddressMap addressMap) {
        if (addressMap.originalToTransformed != null) {
            return new Rva(addressMap.originalToTransformed.lookup(this.address));
        }
        return new Rva(this.address);
    }

    public SectionOffset toSectionOffset(AddressMap addressMap) {
        return this.toRva(addressMap).toSectionOffset(addressMap);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap addressMap) {
        SectionOffset sectionOffset = AddressMap.getSectionOffset(addressMap.originalSections, this.address);
        return new PdbInternalSectionOffset(sectionOffset.getOffset(), sectionOffset.getSection());
    }

    public Long getAddress() {
        return this.address;
    }

    public void setAddress(Long l) {
        this.address = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PdbInternalRva)) {
            return false;
        }
        PdbInternalRva pdbInternalRva = (PdbInternalRva)object;
        if (!pdbInternalRva.canEqual(this)) {
            return false;
        }
        Long l = this.getAddress();
        Long l2 = pdbInternalRva.getAddress();
        return !(l == null ? l2 != null : !((Object)l).equals(l2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PdbInternalRva;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Long l = this.getAddress();
        n2 = n2 * 59 + (l == null ? 43 : ((Object)l).hashCode());
        return n2;
    }

    public String toString() {
        return "PdbInternalRva(address=" + this.getAddress() + ")";
    }
}

