/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.DumpSymType;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.PdbHeaderParser;
import com.uqm.crashsight.symtabtool.pdb.module.source.Line;
import com.uqm.crashsight.symtabtool.pdb.stream.StreamManager;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Vector;

public class PdbParser {
    public String fileName;
    public DumpSymType dumpSymType;
    public boolean dumpCfi;
    public long fileFormat = 0L;
    public String uuid = null;
    public String arch = null;
    public SymbolTable symbolTable = null;
    public PDBInfo pdbInfo = null;
    public String symbolPath = "";
    public String appName = "";
    public boolean useTempDir = false;

    private PdbParser(String string, boolean bl, boolean bl2, boolean bl3) {
        this.fileName = string;
        this.dumpSymType = bl ? DumpSymType.DumpAll : (bl2 ? DumpSymType.DumpCfi : DumpSymType.DumpNone);
        this.useTempDir = bl3;
    }

    public static boolean isPdb(String string) {
        return PdbHeaderParser.isPdb(string);
    }

    public static PdbParser create(String string, boolean bl, boolean bl2, boolean bl3) {
        PdbParser pdbParser = new PdbParser(string, bl, bl2, bl3);
        if (!pdbParser.load()) {
            return null;
        }
        return pdbParser;
    }

    public static String getPdbDebugId(String string) {
        StreamManager.init(string);
        return new PDBInfo().parseDebugId();
    }

    public static Vector<Symbol> breakpadToSymbolTab(String string) {
        Vector<Symbol> vector = new Vector<Symbol>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray;
                if (string2.startsWith("FILE ")) {
                    stringArray = string2.split(" ");
                    hashMap.put(stringArray[1], stringArray[2]);
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.startsWith("FUNC ")) {
                    Object object;
                    stringArray = string2.split(" ");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 4; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                    }
                    string2 = bufferedReader.readLine();
                    if (string2 == null) continue;
                    if (string2.startsWith("FUNC ") || string2.startsWith("PUBLIC ") || string2.startsWith("FILE ")) {
                        Symbol symbol = new Symbol();
                        object = stringArray[1].equals("m") ? stringArray[2] : stringArray[1];
                        String string3 = stringArray[1].equals("m") ? stringArray[3] : stringArray[2];
                        symbol.setAddress(Long.parseLong((String)object, 16));
                        symbol.setEndAddress(symbol.getAddress() + Long.parseLong(string3, 16));
                        symbol.setFunction(stringBuilder.toString());
                        vector.add(symbol);
                        continue;
                    }
                    while (!(string2 == null || string2.startsWith("FUNC ") || string2.startsWith("PUBLIC ") || string2.startsWith("FILE "))) {
                        String[] stringArray2 = string2.split(" ");
                        object = new Symbol();
                        ((Symbol)object).setAddress(Long.parseLong(stringArray2[0], 16));
                        ((Symbol)object).setEndAddress(((Symbol)object).getAddress() + Long.parseLong(stringArray2[1], 16));
                        ((Symbol)object).setFunction(stringBuilder.toString());
                        ((Symbol)object).setSourceFile((String)hashMap.get(stringArray2[3]));
                        ((Symbol)object).setSourceLine(Long.parseLong(stringArray2[2]));
                        vector.add((Symbol)object);
                        string2 = bufferedReader.readLine();
                    }
                    continue;
                }
                string2 = bufferedReader.readLine();
            }
            Log.info("breakpad symbol list len: " + vector.size(), new Object[0]);
        }
        catch (Exception exception) {
            Log.error(exception);
        }
        return vector;
    }

    private String parseAppName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.contains(".")) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    private String pdbSymtabFileNameFormatter() {
        String string = Paths.get(this.fileName, new String[0]).getParent().toString();
        this.appName = this.pdbInfo.pdbName.substring(0, this.pdbInfo.pdbName.lastIndexOf(46));
        if (this.useTempDir) {
            string = System.getProperty("java.io.tmpdir");
        }
        String string2 = "crashsightSymbol";
        string2 = string2 + "&";
        string2 = string2 + this.arch;
        string2 = string2 + "&";
        string2 = string2 + Utils.urlEncodeString(this.appName);
        string2 = string2 + "&";
        string2 = string2 + this.uuid;
        string2 = string2 + ".sym";
        return Paths.get(string, string2).toString();
    }

    private boolean load() {
        try {
            Log.info("Begin to parse file: %s", this.fileName);
            StreamManager.init(this.fileName);
            if (this.dumpCfi) {
                // empty if block
            }
            if (this.dumpSymType == DumpSymType.DumpAll || this.dumpSymType == DumpSymType.DumpCfi) {
                // empty if block
            }
            this.pdbInfo = new PDBInfo(null, this.fileName, null, null);
            if (!this.pdbInfo.parsed) {
                return false;
            }
            this.arch = this.pdbInfo.getCpu().toString();
            this.uuid = this.pdbInfo.getDebugId();
            long l = this.fileFormat = this.arch.contains("64") ? 64L : 32L;
            if (this.dumpSymType != DumpSymType.DumpNone) {
                this.symbolPath = this.pdbSymtabFileNameFormatter();
                BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symbolPath));
                this.pdbInfo.display(bufferedWriter, this.dumpSymType);
                assert (bufferedWriter != null);
                bufferedWriter.flush();
            }
            this.symbolTable = this.getSymbolTable();
            this.pdbInfo = null;
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    SymbolTable getSymbolTable() {
        SymbolTable symbolTable = new SymbolTable();
        for (PDBSymbol pDBSymbol : this.pdbInfo.symbols.getMap().values()) {
            if (pDBSymbol.getSource().getLines().isEmpty()) {
                Symbol symbol = new Symbol();
                symbol.setFunction(pDBSymbol.getName());
                symbol.setAddress(pDBSymbol.getRva());
                symbol.setEndAddress(pDBSymbol.getRva() + pDBSymbol.getLen());
                symbolTable.add(symbol);
                continue;
            }
            for (Line line : pDBSymbol.getSource().getLines()) {
                Symbol symbol = new Symbol();
                symbol.setFunction(pDBSymbol.getName());
                symbol.setAddress(line.getRva());
                symbol.setEndAddress(line.getRva() + line.getLen());
                symbol.setSourceLine(line.getNum());
                symbol.setSourceFile(this.pdbInfo.files.get((int)line.getFileId()));
                symbolTable.add(symbol);
            }
        }
        return symbolTable;
    }
}

