/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;

public class MachHeaderParser {
    private static final long MAGIC_MACH_32_LE = 4277009102L;
    private static final long MAGIC_MACH_32_BE = 3472551422L;
    private static final long MAGIC_MACH_64_LE = 4277009103L;
    private static final long MAGIC_MACH_64_BE = 3489328638L;
    private static final long CPU_TYPE_X86 = 7L;
    private static final long CPU_TYPE_X86_64 = 0x1000007L;
    private static final long CPU_TYPE_ARM = 12L;
    private static final long CPU_TYPE_ARM_64 = 0x100000CL;
    private static final long CPU_TYPE_ARM_V6 = 6L;
    private static final long CPU_TYPE_ARM_V7 = 9L;
    private static final long CPU_TYPE_ARM_V7S = 11L;
    private static final long CPU_TYPE_ARM_64_ALL = 0L;
    private static final long CPU_TYPE_ARM_64_V8 = 1L;
    private static final String CPU_TYPE_UNDEF_STR = "undef_arch";
    private static final String CPU_TYPE_X86_STR = "x86";
    private static final String CPU_TYPE_X86_64_STR = "x86_64";
    private static final String CPU_TYPE_ARM_STR = "arm";
    private static final String CPU_TYPE_ARM_64_STR = "arm64";
    private static final String CPU_TYPE_ARM_V6_STR = "armv6";
    private static final String CPU_TYPE_ARM_V7_STR = "armv7";
    private static final String CPU_TYPE_ARM_V7S_STR = "armv7s";
    private static final String CPU_TYPE_ARM_64_V8_STR = "arm64v8";
    private BinaryFileReader binaryFileReader = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private long magic = 0L;
    private long cpuType = 0L;
    private long cpuSubType = 0L;
    private long fileType = 0L;
    private long commandNumber = 0L;
    private long commandSize = 0L;
    private long flags = 0L;
    private long reserved = 0L;

    public long getFileFormat() {
        return this.fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public long getCommandNumber() {
        return this.commandNumber;
    }

    public long getCommandSize() {
        return this.commandSize;
    }

    public String getArch() {
        return MachHeaderParser.getCpuTypeString(this.cpuType, this.cpuSubType);
    }

    public static String getCpuTypeString(long l, long l2) {
        if (7L == l) {
            return CPU_TYPE_X86_STR;
        }
        if (0x1000007L == l) {
            return CPU_TYPE_X86_64_STR;
        }
        if (12L == l) {
            if (6L == l2) {
                return CPU_TYPE_ARM_V6_STR;
            }
            if (9L == l2) {
                return CPU_TYPE_ARM_V7_STR;
            }
            if (11L == l2) {
                return CPU_TYPE_ARM_V7S_STR;
            }
            return "arm_" + (l & 0xFFL) + "_" + (l2 & 0xFFL);
        }
        if (0x100000CL == l) {
            if (0L == l2) {
                return CPU_TYPE_ARM_64_STR;
            }
            if (1L == l2) {
                return CPU_TYPE_ARM_64_V8_STR;
            }
            return "arm64_" + (l & 0xFFL) + "_" + (l2 & 0xFFL);
        }
        return CPU_TYPE_UNDEF_STR;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    private boolean parseMagic() {
        if (4277009102L == this.magic) {
            this.fileFormat = 32L;
            this.endian = BinaryFileReader.LITTLE_ENDIAN;
        } else if (3472551422L == this.magic) {
            this.fileFormat = 32L;
            this.endian = BinaryFileReader.BIG_ENDIAN;
        } else if (4277009103L == this.magic) {
            this.fileFormat = 64L;
            this.endian = BinaryFileReader.LITTLE_ENDIAN;
        } else if (3489328638L == this.magic) {
            this.fileFormat = 64L;
            this.endian = BinaryFileReader.BIG_ENDIAN;
        } else {
            return false;
        }
        this.binaryFileReader.setEndian(this.endian);
        return true;
    }

    private boolean parseHeader() {
        try {
            this.magic = this.binaryFileReader.readUInt();
            if (!this.parseMagic()) {
                Log.error("Not a MACH-O file", new Object[0]);
                return false;
            }
            this.cpuType = this.binaryFileReader.readUInt();
            this.cpuSubType = this.binaryFileReader.readUInt();
            this.fileType = this.binaryFileReader.readUInt();
            this.commandNumber = this.binaryFileReader.readUInt();
            this.commandSize = this.binaryFileReader.readUInt();
            this.flags = this.binaryFileReader.readUInt();
            if (64L == this.fileFormat) {
                this.reserved = this.binaryFileReader.readUInt();
            }
        }
        catch (IOException iOException) {
            Log.error(iOException);
            return false;
        }
        return true;
    }

    public boolean parse(BinaryFileReader binaryFileReader) {
        this.setBinaryFileReader(binaryFileReader);
        return false != this.parseHeader();
    }

    public static boolean checkMagic(long l) {
        if (4277009102L == l) {
            return true;
        }
        if (3472551422L == l) {
            return true;
        }
        if (4277009103L == l) {
            return true;
        }
        if (3489328638L == l) {
            return true;
        }
        if (3405691582L == l) {
            return true;
        }
        return 3199925962L == l;
    }

    public static boolean isMach(String string) {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(string);
            long l = binaryFileReader.readUInt();
            return MachHeaderParser.checkMagic(l);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }
}

