/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.Upload;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.util.DESUtil;
import com.uqm.crashsight.symtabtool.generic.util.ErrorInfo;
import com.uqm.crashsight.symtabtool.generic.util.NotifyParam;
import com.uqm.crashsight.symtabtool.generic.util.SymbolDuplicateRequestBean;
import com.uqm.crashsight.symtabtool.generic.util.SymbolFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;

public class CosUploader {
    private COSClient cosClient = null;
    private String cosAccessKey = "";
    private String cosSecreteKey = "";
    private String cosSessionToken = "";
    private String cosRegion = "";
    private int platformId = 1;
    private String bucketName = "";
    private String fileObjectKey = "";
    private TransferManager transferManager = null;
    private String appId = "";
    private String appKey = "";
    private String bundleId = "";
    private String appVersion = "";
    private static final String NOTIFY_URL_SUFFIX = "/symbolTool/upload";
    private static final String COS_TOKEN_URL_SUFFIX = "/symbolTool/getSymbolTokenInfo";
    private static final String REPORT_ERROR_URL_SUFFIX = "/symbolTool/saveErrorUploadMessage";
    private static final String LIST_BY_MD5 = "/symbolTool/listByMd5";
    private Vector<SymbolFileInfo> uploadedSymFiles = new Vector();
    private String cosProxyHost = null;
    private static final int MAX_NOTIFY_FILE_LIMIT = 5;
    private String uploadUrl;
    private String cosInnerDomain;
    private AmazonS3 s3client = null;
    private boolean cosInit;
    private ErrorInfo errorInfo = new ErrorInfo();
    private String platform;

    public CosUploader(String string, String string2, String string3, String string4, String string5, String string6) {
        this.appId = string;
        this.appKey = string2;
        this.uploadUrl = string3;
        this.bundleId = string4;
        this.appVersion = string5;
        this.platform = string6;
        this.cosInit = false;
        this.getDirectUploadEnable();
        this.errorInfo.setAppId(string);
        this.errorInfo.setAppKey(string2);
        this.errorInfo.setCosSecreteKey(this.cosSecreteKey);
    }

    public CosUploader(String string) {
        this.uploadUrl = string;
    }

    private AmazonS3 getS3Client() {
        Object object;
        String string = "crashsight-east";
        com.amazonaws.auth.BasicSessionCredentials basicSessionCredentials = new com.amazonaws.auth.BasicSessionCredentials(this.cosAccessKey, this.cosSecreteKey, this.cosSessionToken);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProtocol(Protocol.HTTPS);
        try {
            object = System.getProperties();
            String string2 = ((Properties)object).getProperty("https.proxyHost");
            String string3 = ((Properties)object).getProperty("https.proxyPort");
            if (string2 != null && string3 != null) {
                int n = Integer.parseInt(string3);
                this.cosProxyHost = string2;
                clientConfiguration.setProxyHost(string2);
                clientConfiguration.setProxyPort(n);
                Log.info("Success to set s3 client proxy.", new Object[0]);
            }
        }
        catch (Exception exception) {
            Log.error(exception.getMessage(), new Object[0]);
        }
        object = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(basicSessionCredentials))).withRegion("us-east-2")).withClientConfiguration(clientConfiguration)).build();
        return object;
    }

    private TransferManager createTransferManager() {
        ClientConfig clientConfig = new ClientConfig(new Region(this.cosRegion));
        clientConfig.setConnectionTimeout(2000);
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(this.cosAccessKey, this.cosSecreteKey, this.cosSessionToken);
        this.cosClient = new COSClient(basicSessionCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        TransferManager transferManager = new TransferManager(this.cosClient, executorService);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x3200000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0xA00000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File file, final String string) {
        if (!this.cosInit) {
            Log.error("get cos credentials failed", new Object[0]);
            return false;
        }
        boolean bl = this.bucketName.equals("crashsight-east");
        Log.info("Start to upload symbol file to cos.", new Object[0]);
        final Vector<String> vector = new Vector<String>();
        if (file.isDirectory()) {
            try {
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                        if (path.toFile().getName().endsWith(".zip")) {
                            vector.add(path.toAbsolutePath().toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                Log.error("Failed to collect zip file path:%s", iOException.getMessage());
            }
        } else {
            vector.add(file.getPath());
        }
        Log.info("Target file list size is:%s", vector.size());
        if (this.transferManager == null && !bl) {
            this.transferManager = this.createTransferManager();
        }
        if (bl && this.s3client == null) {
            this.s3client = this.getS3Client();
        }
        this.uploadedSymFiles.clear();
        int n = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        final JsonObject jsonObject = this.listByMd5(vector, string);
        for (final String object22 : vector) {
            Object exception;
            final File n2 = new File(object22);
            if (!n2.exists() || n2.length() <= 0L) continue;
            Log.info("Uploading file %s with size %s", object22, n2.length());
            if (bl) {
                block20: {
                    this.fileObjectKey = this.getCosDstPath(string);
                    boolean string2 = false;
                    try {
                        exception = this.s3client.putObject(this.bucketName, this.fileObjectKey, n2);
                        exception = new SymbolFileInfo(this.bucketName + "/s3/" + this.fileObjectKey, n2, string, (PutObjectResult)exception, this.fileObjectKey);
                        this.uploadedSymFiles.add((SymbolFileInfo)exception);
                        string2 = true;
                        if (string2) break block20;
                    }
                    catch (Exception exception2) {
                        block21: {
                            try {
                                Log.error("Upload to s3 file error:%s", exception2.getMessage());
                                if (string2) break block21;
                            }
                            catch (Throwable throwable) {
                                if (!string2) {
                                    Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                                    break;
                                }
                                Log.info("Success to Upload file %s", n2.getName());
                                throw throwable;
                            }
                            Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                            break;
                        }
                        Log.info("Success to Upload file %s", n2.getName());
                        continue;
                    }
                    Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                    break;
                }
                Log.info("Success to Upload file %s", n2.getName());
                continue;
            }
            final String errorInfo = this.platform;
            exception = executorService.submit(new Callable<JsonObject>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JsonObject call() throws Exception {
                    JsonObject jsonObject3 = new JsonObject();
                    JsonObject jsonObject2 = CosUploader.this.hasFile(object22, jsonObject);
                    if (jsonObject2 != null) {
                        jsonObject3.addProperty("name", n2.getName());
                        jsonObject3.addProperty("time", 0);
                        jsonObject3.addProperty("result", true);
                        SymbolFileInfo symbolFileInfo = new SymbolFileInfo(jsonObject2.get("cosPath").getAsString(), jsonObject2.get("sourceFileName").getAsString(), jsonObject2.get("zippedFileSize").getAsLong(), string, jsonObject2.get("md5").getAsString());
                        CosUploader.this.uploadedSymFiles.add(symbolFileInfo);
                        Log.info("file has been uploaded: " + n2.getName(), new Object[0]);
                    } else {
                        String string2 = CosUploader.this.getCosDstPath(string);
                        PutObjectRequest putObjectRequest = new PutObjectRequest(CosUploader.this.bucketName, string2, n2);
                        putObjectRequest.setStorageClass(StorageClass.Standard_IA);
                        boolean bl = false;
                        boolean bl2 = true;
                        int n = 0;
                        while (bl2) {
                            try {
                                if (CosUploader.this.transferManager == null) {
                                    CosUploader.this.transferManager = CosUploader.this.createTransferManager();
                                }
                                long l = System.currentTimeMillis();
                                Upload upload = CosUploader.this.transferManager.upload(putObjectRequest);
                                UploadResult uploadResult = upload.waitForUploadResult();
                                SymbolFileInfo symbolFileInfo = new SymbolFileInfo(CosUploader.this.bucketName + "/cos/" + string2, n2, string, uploadResult, string2);
                                CosUploader.this.uploadedSymFiles.add(symbolFileInfo);
                                long l2 = System.currentTimeMillis();
                                jsonObject3.addProperty("time", l2 - l);
                                bl = true;
                                bl2 = false;
                            }
                            catch (Exception exception) {
                                if (errorInfo.equals("win") && vector.size() > 100 && n < 10) {
                                    Thread.sleep(60000L);
                                    ++n;
                                } else {
                                    bl2 = false;
                                }
                                Log.error("cos error is: " + exception.getMessage(), new Object[0]);
                                CosUploader.this.errorInfo.addErrorMsg("Upload failed:" + exception.getMessage());
                            }
                            finally {
                                if (!bl) {
                                    Log.error("Upload failed:" + n2.getName(), new Object[0]);
                                    continue;
                                }
                                Log.info("Success to Upload file " + n2.getName(), new Object[0]);
                            }
                        }
                        jsonObject3.addProperty("name", n2.getName());
                        jsonObject3.addProperty("result", bl);
                    }
                    return jsonObject3;
                }
            });
            arrayList.add(exception);
        }
        JsonObject jsonObject2 = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        int n2 = 0;
        for (Object exception : arrayList) {
            try {
                exception = (JsonObject)exception.get();
                if (!((JsonObject)exception).get("result").getAsBoolean()) continue;
                jsonArray.add((JsonElement)exception);
                ++n2;
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        executorService.shutdown();
        jsonObject2.addProperty("all", vector.size());
        jsonObject2.addProperty("success", n2);
        jsonObject2.addProperty("info", jsonArray.toString());
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.setAppKey(this.errorInfo.getAppKey());
        errorInfo.setAppId(this.errorInfo.getAppId());
        errorInfo.setCosSecreteKey(this.errorInfo.getSecretId());
        errorInfo.setType("jar-statistics");
        errorInfo.setUploadResult(jsonObject2.toString());
        this.reportError(errorInfo);
        if (this.transferManager != null) {
            this.transferManager.shutdownNow(true);
            this.transferManager = null;
        }
        if (this.s3client != null) {
            this.s3client.shutdown();
            this.s3client = null;
        }
        if (this.uploadedSymFiles.size() != vector.size()) {
            this.reportError(this.errorInfo);
            return false;
        }
        return this.notifyServer(file, string);
    }

    private boolean notifyServer(File file, String string) {
        NotifyParam notifyParam = new NotifyParam();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        do {
            Vector<SymbolFileInfo> vector;
            if (this.uploadedSymFiles.size() - n2 > 5) {
                n2 = n + 5;
                vector = new Vector<SymbolFileInfo>(this.uploadedSymFiles.subList(n, n2));
                n += 5;
            } else {
                vector = new Vector<SymbolFileInfo>(this.uploadedSymFiles.subList(n, this.uploadedSymFiles.size()));
                bl = true;
            }
            notifyParam.appId = this.appId;
            notifyParam.appKey = this.appKey;
            notifyParam.bundleId = this.bundleId;
            notifyParam.version = this.appVersion;
            notifyParam.platformId = this.platformId;
            notifyParam.symbolFileInfos = vector;
            notifyParam.secretId = this.cosSecreteKey;
            String string2 = "https://" + this.uploadUrl + NOTIFY_URL_SUFFIX;
            MediaType mediaType = MediaType.parse("application/json");
            Gson gson = new Gson();
            Log.info("request param is :%s", gson.toJson(notifyParam));
            RequestBody requestBody = RequestBody.create(mediaType, gson.toJson(notifyParam));
            Request request = new Request.Builder().url(string2).post(requestBody).build();
            String string3 = "";
            JsonObject jsonObject = null;
            JsonParser jsonParser = new JsonParser();
            int n3 = 3;
            do {
                try {
                    string3 = CosUploader.doPostServer(request);
                    if (string3 != null) {
                        Log.info("Upload result is :%s", string3);
                        jsonObject = (JsonObject)jsonParser.parse(string3);
                        if (jsonObject != null && jsonObject.get("code") != null && jsonObject.get("code").getAsString().equals("0")) {
                            Log.info("Success to notify server", new Object[0]);
                            break;
                        }
                    }
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    Log.error("Failed to notify server with msg: %s", exception.getMessage());
                }
            } while (--n3 > 0);
            if (n3 > 0) continue;
            Log.error("Failed to notify server after retry 3 times.", new Object[0]);
            return false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDirectUploadEnable() {
        long l;
        block6: {
            l = System.currentTimeMillis();
            try {
                String string = "https://" + this.uploadUrl + COS_TOKEN_URL_SUFFIX;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("appId", this.appId);
                jsonObject.addProperty("appKey", this.appKey);
                MediaType mediaType = MediaType.parse("application/json");
                RequestBody requestBody = RequestBody.create(mediaType, String.valueOf(jsonObject));
                Request request = new Request.Builder().url(string).post(requestBody).build();
                String string2 = "";
                String string3 = "";
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject2 = null;
                string2 = CosUploader.doPostServer(request);
                jsonObject2 = (JsonObject)jsonParser.parse(string2);
                if (jsonObject2.get("code").getAsString().equals("200")) {
                    string3 = jsonObject2.get("data").getAsString();
                    string3 = DESUtil.decrypt(this.appKey, string3);
                    jsonObject2 = (JsonObject)jsonParser.parse(string3);
                    this.cosAccessKey = jsonObject2.get("tmpSecretId").getAsString();
                    this.cosSecreteKey = jsonObject2.get("tmpSecretKey").getAsString();
                    this.cosSessionToken = jsonObject2.get("sessionToken").getAsString();
                    this.bucketName = jsonObject2.get("bucket").getAsString();
                    this.cosRegion = jsonObject2.get("region").getAsString();
                    this.platformId = jsonObject2.get("platformId").getAsInt();
                    if (jsonObject2.get("internalDomain") != null) {
                        this.cosInnerDomain = jsonObject2.get("internalDomain").getAsString();
                    }
                    this.cosInit = true;
                    break block6;
                }
                Log.error("Failed to get code with info:%s,appId:%s,appKey:%s ", string2, this.appId, this.appKey);
            }
            catch (Exception exception) {
                try {
                    Log.warn("The target server is not support upload with slices: %s", exception.getMessage());
                }
                catch (Throwable throwable) {
                    long l2 = System.currentTimeMillis();
                    Log.info("get cos tmp key cost time: %dms", l2 - l);
                    throw throwable;
                }
                long l3 = System.currentTimeMillis();
                Log.info("get cos tmp key cost time: %dms", l3 - l);
            }
        }
        long l4 = System.currentTimeMillis();
        Log.info("get cos tmp key cost time: %dms", l4 - l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPostServer(Request request) throws InterruptedException, IOException {
        String string = "";
        ConnectionPool connectionPool = new ConnectionPool(0, 5L, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(20L, TimeUnit.SECONDS);
        builder.writeTimeout(20L, TimeUnit.SECONDS);
        builder.readTimeout(20L, TimeUnit.SECONDS);
        builder.connectionPool(connectionPool);
        OkHttpClient okHttpClient = builder.build();
        try (Response response = null;){
            response = okHttpClient.newCall(request).execute();
            assert (response.body() != null);
            string = response.body().string();
        }
        okHttpClient.dispatcher().executorService().shutdown();
        return string;
    }

    private String getCosDstPath(String string) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYY-MM-dd");
        String string2 = simpleDateFormat.format(date);
        String string3 = "";
        if (string.equals("1")) {
            string3 = "java-" + string2;
        } else if (string.equals("2")) {
            string3 = "ios-" + string2;
        } else if (string.equals("3")) {
            string3 = "native-" + string2;
        } else if (string.equals("6")) {
            string3 = "win-" + string2;
        } else if (string.equals("11")) {
            string3 = "win-stif-" + string2;
        } else if (string.equals("12")) {
            string3 = "win-sym-" + string2;
        } else if (string.equals("30")) {
            string3 = "ts-" + string2;
        } else if (string.equals("14")) {
            string3 = "ps-" + string2;
        } else if (string.equals("13")) {
            string3 = "switch-" + string2;
        } else if (string.equals("20")) {
            string3 = "linux-stif-" + string2;
        } else if (string.equals("21")) {
            string3 = "linux-sym-" + string2;
        } else if (string.equals("15")) {
            string3 = "xbox-" + string2;
        }
        string3 = "cst-" + string3 + "-" + UUID.randomUUID().toString() + ".zip";
        return string3;
    }

    private void deleteFiles(Vector<SymbolFileInfo> vector) {
        boolean bl;
        boolean bl2 = bl = this.bucketName.equals("crashsight-east");
        if (bl && this.s3client == null) {
            this.s3client = this.getS3Client();
        }
        if (this.transferManager == null && !bl) {
            this.getDirectUploadEnable();
            this.transferManager = this.createTransferManager();
        }
        for (SymbolFileInfo symbolFileInfo : vector) {
            Log.info("delete file object key:%s,bucket:%s", symbolFileInfo.getFileObjectKey(), this.bucketName);
            if (bl) {
                this.s3client.deleteObject(this.bucketName, symbolFileInfo.getFileObjectKey());
                continue;
            }
            try {
                this.cosClient.deleteObject(this.bucketName, symbolFileInfo.getFileObjectKey());
                Log.info("delete success", new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.transferManager != null) {
            this.transferManager.shutdownNow(true);
            this.transferManager = null;
        }
        if (this.s3client != null) {
            this.s3client.shutdown();
            this.s3client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportError(ErrorInfo errorInfo) {
        long l;
        block6: {
            block7: {
                l = System.currentTimeMillis();
                String string = "https://" + this.uploadUrl + REPORT_ERROR_URL_SUFFIX;
                MediaType mediaType = MediaType.parse("application/json");
                Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy(){

                    @Override
                    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                        String string = "version";
                        return fieldAttributes.getName().equals(string);
                    }

                    @Override
                    public boolean shouldSkipClass(Class<?> clazz) {
                        return false;
                    }
                }).create();
                String string2 = gson.toJson(errorInfo);
                Log.info("Report statistic param info:" + string2, new Object[0]);
                RequestBody requestBody = RequestBody.create(mediaType, string2);
                Request request = new Request.Builder().url(string).post(requestBody).build();
                String string3 = "";
                JsonObject jsonObject = null;
                JsonParser jsonParser = new JsonParser();
                string3 = CosUploader.doPostServer(request);
                if (string3 == null) break block6;
                Log.info("Report statistic result is: " + string3, new Object[0]);
                jsonObject = (JsonObject)jsonParser.parse(string3);
                if (jsonObject == null || jsonObject.get("code") == null || !jsonObject.get("code").getAsString().equals("200")) break block7;
                Log.info("Success to report statistic", new Object[0]);
                boolean bl = true;
                Log.info("report statistic cost %dms", System.currentTimeMillis() - l);
                return bl;
            }
            boolean bl = false;
            Log.info("report statistic cost %dms", System.currentTimeMillis() - l);
            return bl;
        }
        try {
            Log.error("Report statistic response msg is null.", new Object[0]);
        }
        catch (Exception exception) {
            boolean bl;
            try {
                Log.error("Failed to report statistic with msg: " + exception.getMessage(), new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                Log.info("report statistic cost %dms", System.currentTimeMillis() - l);
                throw throwable;
            }
            Log.info("report statistic cost %dms", System.currentTimeMillis() - l);
            return bl;
        }
        Log.info("report statistic cost %dms", System.currentTimeMillis() - l);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject listByMd5(Vector<String> vector, String string) {
        JsonObject exception;
        long l;
        block21: {
            block22: {
                block23: {
                    Object throwable;
                    Object object;
                    Object iOException;
                    Object object2;
                    l = System.currentTimeMillis();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String object52 : vector) {
                        object2 = new File(object52);
                        try {
                            iOException = new FileInputStream((File)object2);
                            object = null;
                            try {
                                throwable = DigestUtils.md5Hex((InputStream)iOException);
                                arrayList.add((String)throwable);
                            }
                            catch (Throwable throwable2) {
                                object = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (iOException == null) continue;
                                if (object != null) {
                                    try {
                                        ((InputStream)iOException).close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                ((InputStream)iOException).close();
                            }
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    if (arrayList.isEmpty()) {
                        return null;
                    }
                    String string2 = "https://" + this.uploadUrl + LIST_BY_MD5;
                    MediaType mediaType = MediaType.parse("application/json");
                    object2 = new SymbolDuplicateRequestBean();
                    ((SymbolDuplicateRequestBean)object2).setMd5List(arrayList);
                    ((SymbolDuplicateRequestBean)object2).setAppId(this.appId);
                    ((SymbolDuplicateRequestBean)object2).setAppKey(this.appKey);
                    ((SymbolDuplicateRequestBean)object2).setSymbolType(string);
                    iOException = new Gson();
                    object = ((Gson)iOException).toJson(object2);
                    Log.info("request param:%s", object);
                    throwable = RequestBody.create(mediaType, (String)object);
                    Request request = new Request.Builder().url(string2).post((RequestBody)throwable).build();
                    String string3 = "";
                    JsonObject jsonObject = null;
                    JsonParser jsonParser = new JsonParser();
                    string3 = CosUploader.doPostServer(request);
                    Log.info("response msg:%s", string3);
                    if (string3 == null) break block21;
                    jsonObject = (JsonObject)jsonParser.parse(string3);
                    if (jsonObject == null || jsonObject.get("code") == null || !jsonObject.get("code").getAsString().equals("200")) break block22;
                    if (!jsonObject.has("data")) break block23;
                    JsonObject jsonObject4 = jsonObject.get("data").getAsJsonObject();
                    Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
                    return jsonObject4;
                }
                JsonObject jsonObject5 = null;
                Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
                return jsonObject5;
            }
            JsonObject jsonObject = null;
            Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
            return jsonObject;
        }
        try {
            exception = null;
        }
        catch (Exception exception2) {
            JsonObject jsonObject;
            try {
                jsonObject = null;
            }
            catch (Throwable throwable) {
                Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
                throw throwable;
            }
            Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
            return jsonObject;
        }
        Log.info("listByMd5 request cost %dms", System.currentTimeMillis() - l);
        return exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject hasFile(String string, JsonObject jsonObject) {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            String string2 = DigestUtils.md5Hex(fileInputStream);
            if (jsonObject == null) return null;
            if (!jsonObject.has(string2)) return null;
            JsonObject jsonObject3 = jsonObject.get(string2).getAsJsonObject();
            jsonObject3.addProperty("md5", string2);
            JsonObject jsonObject2 = jsonObject3;
            return jsonObject2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static interface MappingTypeUtil {
        public static final String MAPPING_JAVA = "1";
        public static final String MAPPING_IOS = "2";
        public static final String MAPPING_NATIVE = "3";
        public static final String MAPPING_PLUGIN = "4";
        public static final String MAPPING_UNITY = "5";
        public static final String MAPPING_WINDOWS = "6";
        public static final String MAPPING_WINDOWS_STIF = "11";
        public static final String MAPPING_WINDOWS_SYM = "12";
        public static final String MAPPING_JS = "30";
        public static final String MAPPING_PS = "14";
        public static final String MAPPING_NSS = "13";
        public static final String MAPPING_XBOX = "15";
        public static final String MAPPING_LINUX_STIF = "20";
        public static final String MAPPING_LINUX_SYM = "21";
    }
}

