/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SymtabExtractorPs {
    public static String extract(ArgsParser argsParser) {
        Object object3;
        Object object2;
        String string = argsParser.getFileName();
        String string2 = null;
        try {
            object2 = Files.createTempDirectory("tmp", new FileAttribute[0]);
            string2 = object2.toAbsolutePath().toString();
        }
        catch (Exception exception) {
            Log.error("Create temp directory failed", new Object[0]);
            SymtabToolClient.getErrorInfo().addErrorMsg("Create temp directory failed");
            return null;
        }
        object2 = SymtabExtractorPs.getPs5SymbolFiles(string);
        Vector<File> vector = new Vector<File>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object3 : object2.values()) {
            String string3 = ((File)object3).getName();
            String string4 = ElfParser.getUuid(((File)object3).getAbsolutePath(), true);
            if (!hashSet.add(string4)) continue;
            String string5 = string2 + File.separator + string4 + "_" + string3;
            File file = new File(string5);
            try {
                Files.copy(((File)object3).toPath(), file.toPath(), new CopyOption[0]);
            }
            catch (Exception exception) {
                SymtabToolClient.getErrorInfo().addErrorMsg(exception.getMessage());
            }
            vector.add(file);
        }
        object2.clear();
        Object object4 = argsParser.getStifZipFileName();
        if (object4 == null) {
            object4 = string + "crashsightSymbol-" + UUID.randomUUID() + ".zip";
        }
        if (StringUtils.isNotBlank((CharSequence)(object3 = SymtabExtractorPs.zipSymtabFiles((String)object4, vector)))) {
            return new File((String)object3).getAbsolutePath();
        }
        return null;
    }

    private static Map<String, File> getPs5SymbolFiles(String string) {
        Map<String, File> map = null;
        try (Stream<Path> stream = Files.walk(Paths.get(string, new String[0]), new FileVisitOption[0]);){
            map = stream.filter(path -> path.toString().endsWith(".self") || path.toString().endsWith(".prx") || path.toString().endsWith(".sym")).distinct().collect(Collectors.toMap(Path::toString, path -> path.toFile()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return map;
    }

    public static String getZipFileName(ArgsParser argsParser) {
        String string = argsParser.getStifZipFileName();
        File file = null;
        if (string != null) {
            file = new File(string);
        } else {
            try {
                file = File.createTempFile("tmp", ".zip");
            }
            catch (IOException iOException) {
                Log.error("Create temp file failed", new Object[0]);
                System.exit(-4);
            }
        }
        return file.getAbsolutePath();
    }

    public static String zipSymtabFiles(String string, Vector<File> vector) {
        Log.info("Begin to zip symtab file: " + string, new Object[0]);
        if (FileHelper.zipFiles(vector, string)) {
            Log.info("Successfully zipped symtab file!", new Object[0]);
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
        }
        for (File file : vector) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        return string;
    }
}

