/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.generic.util.Common;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class SymtabExtractorNss {
    public static String extract(ArgsParser argsParser) {
        String string = argsParser.getFileName();
        final ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = null;
        try {
            Files.walkFileTree(new File(string).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    if (path.toFile().getName().endsWith(".nss")) {
                        arrayList.add(path.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (arrayList.size() == 0) {
                Log.info("no nss file found", new Object[0]);
                return null;
            }
            File file = Common.zipFile(arrayList, "nssFile");
            string2 = file.getAbsolutePath();
        }
        catch (Exception exception) {
            SymtabToolClient.getErrorInfo().addErrorMsg(exception.getMessage());
            Log.error(exception.getMessage(), new Object[0]);
        }
        return string2;
    }
}

